/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.PlayerPerTeamSetting;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.ColorConverter;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.NMSScoreboardBuilder;
import de.eisi05.bingo.utils.eisutils.builder.RecipeInventory;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BingoTeam {
    public static final List<BingoTeam> teams = new ArrayList<BingoTeam>();
    private final int id;
    private final NamedTextColor color;
    private final Set<UUID> players = new HashSet<UUID>();
    private final List<BingoObject<?>> collectedObjects = new ArrayList();
    private final List<AdvancementProgress> advancementProgresses = new ArrayList<AdvancementProgress>();
    private final Inventory backpack;

    private BingoTeam(int id, NamedTextColor color) {
        this.id = id;
        this.color = color;
        this.backpack = Bukkit.createInventory(null, (int)27, (Component)Component.translatable((String)"team.backpack", (String)"Backpack"));
        teams.add(this);
    }

    public static Optional<BingoTeam> getTeam(UUID player) {
        for (BingoTeam team : teams) {
            if (!team.getPlayers().contains(player)) continue;
            return Optional.of(team);
        }
        return Optional.empty();
    }

    public static void createBingoTeams() {
        ArrayList<NamedTextColor> colors = new ArrayList<NamedTextColor>(List.of(BingoUtils.teamColors));
        for (int i = 0; i < 9; ++i) {
            new BingoTeam(i + 1, (NamedTextColor)colors.remove(new Random().nextInt(colors.size())));
        }
    }

    public static InventoryBuilder getSelectionInventory(Player player) {
        LinkedList<BingoTeam> sorted = BingoTeam.getSortedTeams();
        int invSize = sorted.size() % 9 == 0 ? sorted.size() : (sorted.size() / 9 + 1) * 9;
        InventoryBuilder inventoryBuilder = new InventoryBuilder((InventoryHolder)new BingoTeamInventoryHolder(), invSize, (Component)Component.translatable((String)"options.teamSelection.title", (String)"Team Selection"));
        for (int i = 0; i < sorted.size(); ++i) {
            BingoTeam current = (BingoTeam)sorted.get(i);
            inventoryBuilder.setItem(i, current.getIcon().setEnchantmentGlint(current.players.contains(player.getUniqueId())).setClickHandler(event -> {
                if (current.isFull()) {
                    BingoUtils.sendMessage(event.getWhoClicked(), Component.translatable((String)"team.full", (String)"This team is full!").color((TextColor)NamedTextColor.RED), true);
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
                BingoTeam.getTeam(event.getWhoClicked().getUniqueId()).ifPresent(team -> team.removePlayer(event.getWhoClicked()));
                current.addPlayer(event.getWhoClicked());
                event.getWhoClicked().closeInventory();
                BingoTeam.updateInventory();
                BingoUtils.sendMessage(event.getWhoClicked(), Component.translatable((String)"team.joined", (String)("You joined team " + LegacyComponentSerializer.legacySection().serialize((Component)current.getName())), (ComponentLike[])new ComponentLike[]{current.getName()}).color((TextColor)NamedTextColor.GRAY), true);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            }).build());
        }
        return inventoryBuilder.normal();
    }

    private static void updateInventory() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.getOpenInventory() == null) continue;
            if (player.getOpenInventory().getTopInventory() == null) {
                return;
            }
            if (player.getOpenInventory().getTopInventory().getHolder() == null) {
                return;
            }
            if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof BingoTeamInventoryHolder)) continue;
            BingoTeam.getSelectionInventory(player).open((HumanEntity)player);
        }
    }

    public static LinkedList<BingoTeam> getSortedTeams() {
        return new LinkedList<BingoTeam>(teams.stream().sorted(Comparator.comparingInt(value -> value.id)).toList());
    }

    public static void addPlayerToSpectator(HumanEntity player) {
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).addPlayerToTeamByEntry((OfflinePlayer)((Player)player), "team0"));
    }

    public int getId() {
        return this.id;
    }

    public NamedTextColor getColor() {
        return this.color;
    }

    public TextComponent getName() {
        return (TextComponent)Component.text((String)("#" + this.id)).color((TextColor)this.color);
    }

    public String getNameAsString() {
        return String.valueOf(this.color) + "#" + this.id;
    }

    public Inventory getBackpack() {
        return this.backpack;
    }

    public ItemBuilder getIcon() {
        ItemBuilder itemBuilder = new ItemBuilder(Material.valueOf((String)(ColorConverter.getColor(this.color).name() + "_BED"))).setName((Component)this.getName());
        ArrayList<Component> lore = new ArrayList<Component>();
        for (UUID uuid : this.players) {
            lore.add(((TextComponent)Component.text((String)Bukkit.getPlayer((UUID)uuid).getName()).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        }
        for (int i = lore.size(); i < (Integer)BingoSetting.getSetting(PlayerPerTeamSetting.class).getValue(); ++i) {
            lore.add(((TextComponent)Component.text((String)" --- ").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false));
        }
        return itemBuilder.setLore(lore.toArray(new Component[0]));
    }

    public boolean isFull() {
        return this.players.size() == ((Integer)BingoSetting.getSetting(PlayerPerTeamSetting.class).getValue()).intValue();
    }

    public void addPlayer(HumanEntity player) {
        this.players.add(player.getUniqueId());
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).addPlayerToTeam((OfflinePlayer)((Player)player), this.getNameAsString()));
    }

    public void removePlayer(HumanEntity player) {
        this.players.remove(player.getUniqueId());
        Bukkit.getOnlinePlayers().forEach(online -> new NMSScoreboardBuilder((Player)online).removePlayerFromTeam((OfflinePlayer)((Player)player), this.getNameAsString()));
    }

    public void foundBingoItem(BingoObject<?> bingoObject) {
        this.collectedObjects.add(bingoObject);
    }

    public Set<BingoObject<?>> getMissingBingoItems() {
        return BingoObject.getSelectedObjects().stream().filter(bingoObject -> !this.collectedObjects.contains(bingoObject)).collect(Collectors.toSet());
    }

    public void updateAdvancementProgresses() {
        this.getPlayers().stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).forEach(player -> BingoObject.getBingoObjects(BingoObject.BingoAdvancement.class).forEach(bingoAdvancement -> {
            AdvancementProgress progress = player.getPlayer().getAdvancementProgress((Advancement)bingoAdvancement.getObject());
            this.advancementProgresses.stream().filter(advancementProgress -> advancementProgress.getAdvancement().equals((Object)progress.getAdvancement())).findFirst().ifPresentOrElse(advancementProgress -> {
                if (advancementProgress.getAwardedCriteria().size() > progress.getAwardedCriteria().size()) {
                    advancementProgress.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)progress).awardCriteria(arg_0));
                } else if (advancementProgress.getAwardedCriteria().size() < progress.getAwardedCriteria().size()) {
                    progress.getAwardedCriteria().forEach(arg_0 -> ((AdvancementProgress)advancementProgress).awardCriteria(arg_0));
                }
            }, () -> this.advancementProgresses.add(progress));
        }));
    }

    public LinkedList<ItemStack> getBingoItems() {
        return BingoObject.getSelectedObjects().stream().map(this::lambda$getBingoItems$15).collect(Collectors.toCollection(LinkedList::new));
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private /* synthetic */ ItemStack lambda$getBingoItems$15(BingoObject bingoObject) {
        if (bingoObject.hasFound(this)) {
            return new ItemBuilder(Material.LIME_STAINED_GLASS_PANE).setEnchantmentGlint(true).setName(bingoObject.asDisplayIcon().getItemMeta().displayName()).clearAttributes().hideToolTip().build();
        }
        preLore = null;
        if (bingoObject instanceof BingoObject.BingoAdvancement) {
            bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
            preLore = Component.translatable((String)("advancements." + ((Advancement)bingoAdvancement.object).getKey().getKey().replace("/", ".") + ".description"), (String)PlainTextComponentSerializer.plainText().serialize(((Advancement)bingoAdvancement.object).getDisplay().description()));
        }
        v0 = (TextComponent)((TextComponent)Component.text((String)"> ").append(BingoObject.getName(bingoObject.getClass()))).color((TextColor)NamedTextColor.GRAY);
        if (!(bingoObject instanceof BingoObject.BingoAdvancement)) ** GOTO lbl-1000
        bingoAdvancement = (BingoObject.BingoAdvancement)bingoObject;
        if (((Advancement)bingoAdvancement.object).getCriteria().size() > 1) {
            v1 = " (" + String.valueOf(this.advancementProgresses.stream().filter((Predicate<AdvancementProgress>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getBingoItems$12(de.eisi05.bingo.bingo.BingoObject$BingoAdvancement org.bukkit.advancement.AdvancementProgress ), (Lorg/bukkit/advancement/AdvancementProgress;)Z)((BingoObject.BingoAdvancement)bingoAdvancement)).map((Function<AdvancementProgress, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBingoItems$13(org.bukkit.advancement.AdvancementProgress ), (Lorg/bukkit/advancement/AdvancementProgress;)Ljava/lang/Integer;)()).findFirst().orElse(0)) + "/" + ((Advancement)bingoAdvancement.object).getCriteria().size() + ")";
        } else lbl-1000:
        // 2 sources

        {
            v1 = "";
        }
        v2 = Component.text((String)v1);
        if (bingoObject instanceof BingoObject.BingoItem) {
            bingoItem = (BingoObject.BingoItem)bingoObject;
            v3 /* !! */  = new RecipeInventory(((ItemStack)bingoItem.object).getType()).isCraftable() ? ((TextComponent)((TextComponent)((TextComponent)Component.text((String)" (").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, true)).append((Component)Component.translatable((String)"de.eisi05.bingo.item.recipe.found", (String)"Click to view Recipe"))).append((Component)Component.text((String)")")) : Component.empty();
        } else {
            v3 /* !! */  = Component.empty();
        }
        lore = v0.append(v2.append((Component)v3 /* !! */ ));
        v4 = new ItemBuilder(bingoObject.asDisplayIcon());
        if (preLore == null) {
            v5 = new Component[1];
            v6 = v5;
            v5[0] = lore;
        } else {
            v7 = new Component[3];
            v7[0] = preLore;
            v7[1] = Component.empty();
            v6 = v7;
            v7[2] = lore;
        }
        return v4.setLore(v6).setClickHandler((Consumer<InventoryClickEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getBingoItems$14(org.bukkit.event.inventory.InventoryClickEvent ), (Lorg/bukkit/event/inventory/InventoryClickEvent;)V)()).build();
    }

    private static /* synthetic */ void lambda$getBingoItems$14(InventoryClickEvent event) {
        Component message = Component.translatable((String)"de.eisi05.bingo.item.recipe.none", (String)"Item cannot be crafted!").color((TextColor)NamedTextColor.RED);
        if (!new RecipeInventory(event.getCurrentItem().getType()).setNotFoundMessage(message).open((Player)event.getWhoClicked())) {
            BingoUtils.sendMessage(event.getWhoClicked(), message, true);
        }
    }

    private static /* synthetic */ Integer lambda$getBingoItems$13(AdvancementProgress advancementProgress) {
        return advancementProgress.getAwardedCriteria().size();
    }

    private static /* synthetic */ boolean lambda$getBingoItems$12(BingoObject.BingoAdvancement bingoAdvancement, AdvancementProgress advancementProgress) {
        return advancementProgress.getAdvancement().equals(bingoAdvancement.object);
    }

    public static class BingoTeamInventoryHolder
    implements InventoryHolder {
        @NotNull
        public Inventory getInventory() {
            return null;
        }
    }
}

