/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class AmountOfObjectsSetting
extends BingoSetting<Integer> {
    AmountOfObjectsSetting() {
    }

    @Override
    public Integer getDefaultValue() {
        return 9;
    }

    @Override
    public ItemBuilder getIcon() {
        return new ItemBuilder(Material.CHEST).setName(((TranslatableComponent)Component.translatable((String)"options.amountOfObjects.title", (String)"Amount of Objects").color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false)).setLore(Translation.value(Component.text((int)((Integer)this.getValue())).color((TextColor)NamedTextColor.GOLD), (TextColor)NamedTextColor.GRAY)).addLore(this.getDescription(true)).setClickHandler(event -> {
            if (event.getClick().isLeftClick()) {
                this.setValue((Integer)this.getValue() + 1);
            } else if (event.getClick().isRightClick()) {
                if ((Integer)this.getValue() > 1) {
                    this.setValue((Integer)this.getValue() - 1);
                } else {
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
            }
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            List<Component> lore = ItemBuilder.getLore(currentItem);
            lore.set(0, Translation.value(Component.text((int)((Integer)this.getValue())).color((TextColor)NamedTextColor.GOLD), (TextColor)NamedTextColor.GRAY));
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, lore).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public Component getSettingsText() {
        return ((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"options.amountOfObjects.title", (String)"Amount of Objects").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false)).append(((TextComponent)Component.text((String)": ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((int)((Integer)this.getValue())).color((TextColor)NamedTextColor.BLUE)));
    }

    @Override
    public int getSlot() {
        return 24;
    }

    @Override
    public List<Triple<String, String, Boolean>> getDescriptionKeys() {
        return List.of(Triple.of((Object)"options.amountOfObjects.description.1", (Object)"Amount of Objects in the game", (Object)false), Triple.of((Object)"options.amountOfObjects.description.2", (Object)"that need to be found, completed, ...", (Object)false), Triple.of((Object)"options.amountOfObjects.description.3", (Object)"Right-click -> -1", (Object)true), Triple.of((Object)"options.amountOfObjects.description.4", (Object)"Left-click -> +1", (Object)true));
    }
}

