/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.settings.AllowEnchantmentsSetting;
import de.eisi05.bingo.bingo.settings.AmountOfObjectsSetting;
import de.eisi05.bingo.bingo.settings.DamageSetting;
import de.eisi05.bingo.bingo.settings.DifficultySetting;
import de.eisi05.bingo.bingo.settings.EndSetting;
import de.eisi05.bingo.bingo.settings.KeepInventorySetting;
import de.eisi05.bingo.bingo.settings.ManageObjectsSetting;
import de.eisi05.bingo.bingo.settings.NetherSetting;
import de.eisi05.bingo.bingo.settings.ObjectTypesSetting;
import de.eisi05.bingo.bingo.settings.PVPSetting;
import de.eisi05.bingo.bingo.settings.PlayerPerTeamSetting;
import de.eisi05.bingo.bingo.settings.RandomizerSetting;
import de.eisi05.bingo.bingo.settings.ServerRestartSetting;
import de.eisi05.bingo.bingo.settings.TimeSetting;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.config.Configuration;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.component.ItemLore;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract sealed class BingoSetting<T>
permits AllowEnchantmentsSetting, AmountOfObjectsSetting, DamageSetting, DifficultySetting, EndSetting, KeepInventorySetting, ManageObjectsSetting, NetherSetting, ObjectTypesSetting, PVPSetting, PlayerPerTeamSetting, RandomizerSetting, ServerRestartSetting, TimeSetting {
    private static final String filePath = "BingoSettings.yml";
    private static final HashMap<BingoSetting<?>, Object> map = new HashMap();
    private static final HashMap<Class<? extends BingoSetting<?>>, BingoSetting<?>> settings = new HashMap();

    public static <T extends BingoSetting<?>> T getSetting(Class<T> clazz) {
        return (T)settings.get(clazz);
    }

    public static BingoSetting<?>[] values() {
        return settings.values().toArray(new BingoSetting[0]);
    }

    protected void handleBooleanSetting(BingoSetting<Boolean> setting, ItemStack item) {
        setting.setValue(setting.getValue() == false);
        ItemMeta meta = item.getItemMeta();
        meta.setEnchantmentGlintOverride(setting.getValue());
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        List lore = ((ItemLore)nmsItemStack.get(DataComponents.LORE)).lines();
        lore.set(0, setting.getValue() != false ? Component.translatableWithFallback((String)"addServer.resourcePack.enabled", (String)"Enabled").withStyle(style -> style.withColor(ChatFormatting.GREEN).withItalic(Boolean.valueOf(false))) : Component.translatableWithFallback((String)"addServer.resourcePack.disabled", (String)"Disabled").withStyle(style -> style.withColor(ChatFormatting.RED).withItalic(Boolean.valueOf(false))));
        nmsItemStack.applyComponents(DataComponentMap.builder().set(DataComponents.LORE, (Object)lore.stream().reduce(ItemLore.EMPTY, ItemLore::withLineAdded, (lore1, lore2) -> lore1)).set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)setting.getValue()).build());
        item.setItemMeta(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack).getItemMeta());
    }

    public abstract T getDefaultValue();

    public abstract ItemBuilder getIcon();

    public abstract net.kyori.adventure.text.Component getSettingsText();

    public abstract int getSlot();

    public abstract List<Triple<String, String, Boolean>> getDescriptionKeys();

    protected net.kyori.adventure.text.Component[] getDescription(boolean withNewLine) {
        Stream<net.kyori.adventure.text.Component> componentStream = this.getDescriptionKeys().stream().map(entry -> ((TranslatableComponent)net.kyori.adventure.text.Component.translatable((String)((String)entry.getLeft()), (String)((String)entry.getMiddle())).color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, ((Boolean)entry.getRight()).booleanValue()));
        if (withNewLine) {
            componentStream = Stream.concat(Stream.of(net.kyori.adventure.text.Component.empty()), componentStream);
        }
        return componentStream.toList().toArray(new net.kyori.adventure.text.Component[0]);
    }

    public T getValue() {
        if (!map.containsKey(this)) {
            return this.getDefaultValue();
        }
        return (T)map.get(this);
    }

    public void setValue(T t) {
        map.put(this, t);
        Configuration.MyConfig config = new Configuration(Main.plugin.getDataFolder(), filePath).getConfig();
        config.set(this.getClass().getSimpleName(), this.serialize(t));
    }

    public Object serialize(T t) {
        return t;
    }

    public T deserialize(Object o) {
        return (T)o;
    }

    static {
        for (Class<?> setting : BingoSetting.class.getPermittedSubclasses()) {
            try {
                Object object;
                BingoSetting bingoSetting = (BingoSetting)setting.getDeclaredConstructors()[0].newInstance(new Object[0]);
                settings.put(setting, bingoSetting);
                Configuration.MyConfig config = new Configuration(Main.plugin.getDataFolder(), filePath).getConfig();
                if (bingoSetting.getDefaultValue() == null || !config.contains(bingoSetting.getClass().getSimpleName()) || (object = config.get(bingoSetting.getClass().getSimpleName())) == null) continue;
                map.put(bingoSetting, bingoSetting.deserialize(object));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

