/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.BingoDifficulty;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class DifficultySetting
extends BingoSetting<BingoDifficulty> {
    DifficultySetting() {
    }

    @Override
    public BingoDifficulty getDefaultValue() {
        return BingoDifficulty.NORMAL;
    }

    @Override
    public ItemBuilder getIcon() {
        return new ItemBuilder(Material.BEACON).setName(((TranslatableComponent)Component.translatable((String)"options.difficulty.title", (String)"Difficulty").color((TextColor)NamedTextColor.YELLOW)).decoration(TextDecoration.ITALIC, false)).setLore(this.getLore().toArray(new Component[0])).addLore(this.getDescription(true)).setClickHandler(event -> {
            this.setValue(event.getClick().isLeftClick() ? ((BingoDifficulty)this.getValue()).next(false) : ((BingoDifficulty)this.getValue()).prev(false));
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, Stream.concat(this.getLore().stream(), Arrays.stream(this.getDescription(true))).toList()).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public Component getSettingsText() {
        return ((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"options.difficulty.title", (String)"Difficulty").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false)).append(Component.text((String)": ").append(((BingoDifficulty)this.getValue()).getName()));
    }

    private List<Component> getLore() {
        return Arrays.stream(BingoDifficulty.getAll()).map(bingoDifficulty -> this.getValue() == bingoDifficulty ? bingoDifficulty.getName() : bingoDifficulty.getName().color((TextColor)NamedTextColor.GRAY)).toList();
    }

    @Override
    public int getSlot() {
        return 33;
    }

    @Override
    public List<Triple<String, String, Boolean>> getDescriptionKeys() {
        return List.of(Triple.of((Object)"options.difficulty.description.1", (Object)"Sets the difficulty of the Game", (Object)false), Triple.of((Object)"options.difficulty.description.2", (Object)("(Difficulties can be set via " + String.valueOf(NamedTextColor.YELLOW) + "Manage Objects" + String.valueOf(NamedTextColor.GRAY) + ")"), (Object)false));
    }

    @Override
    public Object serialize(BingoDifficulty bingoDifficulty) {
        return bingoDifficulty.name();
    }

    @Override
    public BingoDifficulty deserialize(Object o) {
        return BingoDifficulty.valueOf(o.toString());
    }
}

