/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class ServerRestartSetting
extends BingoSetting<Integer> {
    ServerRestartSetting() {
    }

    @Override
    public Integer getDefaultValue() {
        return 30;
    }

    @Override
    public ItemBuilder getIcon() {
        return new ItemBuilder(Material.COMPARATOR).setName(((TranslatableComponent)Component.translatable((String)"options.restart.title", (String)"Server Restart").color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.ITALIC, false)).setLore(this.getLore().toArray(new Component[0])).setClickHandler(event -> {
            if (event.getClick().isLeftClick()) {
                this.setValue((Integer)this.getValue() + 15);
            } else if (event.getClick().isRightClick()) {
                if ((long)((Integer)this.getValue()).intValue() > 0L) {
                    this.setValue((Integer)this.getValue() - 15);
                } else {
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
            }
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, this.getLore()).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public Component getSettingsText() {
        return null;
    }

    @Override
    public int getSlot() {
        return 4;
    }

    private List<Component> getLore() {
        return Stream.concat(Stream.of(Translation.value((long)((Integer)this.getValue()).intValue() == 0L ? ((TranslatableComponent)Component.translatable((String)"options.manually", (String)"Manually").color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.ITALIC, false) : ((TranslatableComponent)Component.translatable((String)"options.sec", (String)(String.valueOf(this.getValue()) + "sec"), (ComponentLike[])new ComponentLike[]{Component.text((int)((Integer)this.getValue()))}).color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.ITALIC, false), (TextColor)NamedTextColor.GRAY)), Arrays.stream(this.getDescription(true))).toList();
    }

    @Override
    public List<Triple<String, String, Boolean>> getDescriptionKeys() {
        return List.of(Triple.of((Object)"options.restart.description.1", (Object)"The time between finishing the game", (Object)false), Triple.of((Object)"options.restart.description.2", (Object)"and the server restart", (Object)false), Triple.of((Object)"options.restart.description.3", (Object)"(0 = manually with /restart)", (Object)false), Triple.of((Object)"options.restart.description.4", (Object)"Right click -> -15sec", (Object)true), Triple.of((Object)"options.restart.description.5", (Object)"Left click -> +15sec", (Object)true));
    }
}

