/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class TimeSetting
extends BingoSetting<Integer> {
    TimeSetting() {
    }

    @Override
    public Integer getDefaultValue() {
        return 30;
    }

    @Override
    public ItemBuilder getIcon() {
        return new ItemBuilder(Material.CLOCK).setName(((TranslatableComponent)Component.translatable((String)"options.time.title", (String)"Time").color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false)).setLore(this.getLore().toArray(new Component[0])).setClickHandler(event -> {
            if (event.getClick().isLeftClick()) {
                this.setValue((Integer)this.getValue() + 15);
            } else if (event.getClick().isRightClick()) {
                if ((long)((Integer)this.getValue()).intValue() > 0L) {
                    this.setValue((Integer)this.getValue() - 15);
                } else {
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
            }
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, this.getLore()).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public Component getSettingsText() {
        return ((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"options.time.title", (String)"Time").color((TextColor)NamedTextColor.GRAY)).decoration(TextDecoration.ITALIC, false)).append(Component.text((String)": ").append((long)((Integer)this.getValue()).intValue() == 0L ? Translation.INFINITE.color((TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false) : ((TranslatableComponent)Component.translatable((String)"options.min", (String)(String.valueOf(this.getValue()) + "min"), (ComponentLike[])new ComponentLike[]{Component.text((int)((Integer)this.getValue()))}).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.ITALIC, false)));
    }

    private List<Component> getLore() {
        return Stream.concat(Stream.of(Translation.value((long)((Integer)this.getValue()).intValue() == 0L ? Translation.INFINITE.color((TextColor)NamedTextColor.BLUE).decoration(TextDecoration.ITALIC, false) : ((TranslatableComponent)Component.translatable((String)"options.min", (String)(String.valueOf(this.getValue()) + "min"), (ComponentLike[])new ComponentLike[]{Component.text((int)((Integer)this.getValue()))}).color((TextColor)NamedTextColor.BLUE)).decoration(TextDecoration.ITALIC, false), (TextColor)NamedTextColor.GRAY)), Arrays.stream(this.getDescription(true))).toList();
    }

    @Override
    public int getSlot() {
        return 22;
    }

    @Override
    public List<Triple<String, String, Boolean>> getDescriptionKeys() {
        return List.of(Triple.of((Object)"options.time.description.1", (Object)"The time of the game (0 = infinite)", (Object)false), Triple.of((Object)"options.time.description.2", (Object)"Right click -> -15min", (Object)true), Triple.of((Object)"options.time.description.3", (Object)"Left click -> +15min", (Object)true));
    }
}

