/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.libs.commandapi.executors.CommandArguments;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public non-sealed class BingoCommand
extends AbstractCommand
implements InventoryHolder {
    public BingoCommand() {
        super("bingo", "command.de.eisi05.bingo.description", "Opens the de.eisi05.bingo board");
        this.withPermission("bingo");
        this.withFullDescription("Opens the de.eisi05.bingo board");
        this.executesPlayer((Player player, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)player, Component.translatable((String)"game.none", (String)"There is no game running!").color((TextColor)NamedTextColor.RED), true);
                return;
            }
            Optional<BingoTeam> team = BingoTeam.getTeam(player.getUniqueId());
            if (team.isEmpty()) {
                BingoUtils.sendMessage((HumanEntity)player, Component.translatable((String)"team.none", (String)"You are not in any team!").color((TextColor)NamedTextColor.RED), true);
                return;
            }
            player.openInventory(this.getBingoInventory(team.get()));
        });
        this.register();
    }

    private Inventory getBingoInventory(BingoTeam team) {
        int maxInvSize = 54;
        if (BingoObject.getSelectedObjects().size() < maxInvSize) {
            InventoryType type = switch (BingoObject.getSelectedObjects().size()) {
                case 1, 2, 3, 4, 5 -> InventoryType.HOPPER;
                case 9 -> InventoryType.DROPPER;
                default -> InventoryType.CHEST;
            };
            int objects = BingoObject.getSelectedObjects().size();
            int invSize = objects % 9 == 0 ? objects : (objects / 9 + 1) * 9;
            InventoryBuilder inventoryBuilder = type == InventoryType.CHEST ? new InventoryBuilder((InventoryHolder)this, invSize, (Component)Component.text((String)"Bingo")) : new InventoryBuilder((InventoryHolder)this, type, (Component)Component.text((String)"Bingo"));
            inventoryBuilder.addItems(team.getBingoItems());
            return inventoryBuilder.normal().build();
        }
        return new ScrollInventory(this, (Component)Component.text((String)"Bingo"), team.getBingoItems(), true, new ScrollInventory.Hotbar[0]).setArrowBackEvent(event -> event.getWhoClicked().closeInventory()).start();
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }
}

