/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.libs.commandapi.arguments.Argument;
import de.eisi05.bingo.libs.commandapi.arguments.GreedyStringArgument;
import de.eisi05.bingo.libs.commandapi.executors.CommandArguments;
import de.eisi05.bingo.utils.BingoUtils;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public non-sealed class TeamChatCommand
extends AbstractCommand {
    public TeamChatCommand() {
        super("teamchat", "command.teamchat.description", "Sends a message to your team");
        this.withPermission("bingo");
        this.withAliases("teamtell", "teammsg");
        this.withFullDescription("Sends a message to the team chat");
        this.withArguments(new Argument[]{new GreedyStringArgument("message")});
        this.executesPlayer((Player player, CommandArguments commandArguments) -> {
            Optional<BingoTeam> optionalTeam = BingoTeam.getTeam(player.getUniqueId());
            if (optionalTeam.isEmpty()) {
                BingoUtils.sendMessage((HumanEntity)player, Component.translatable((String)"team.none", (String)"You are not in any team!").color((TextColor)NamedTextColor.RED), true);
                return;
            }
            String message = (String)commandArguments.get("message");
            BingoTeam team = optionalTeam.get();
            team.getPlayers().stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).forEach(player1 -> BingoUtils.sendMessage((HumanEntity)player1.getPlayer(), ((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)((TranslatableComponent)Component.translatable((String)"[").append((Component)Component.translatable((String)"team.teamchat", (String)"Teamchat"))).color((TextColor)NamedTextColor.DARK_AQUA)).decoration(TextDecoration.BOLD, true)).append((Component)Component.text((String)"] "))).append(player.displayName().color((TextColor)NamedTextColor.YELLOW).decoration(TextDecoration.BOLD, false).append(((TextComponent)((TextComponent)Component.text((String)" -> ").color((TextColor)NamedTextColor.DARK_GRAY)).decoration(TextDecoration.BOLD, false)).append(((TextComponent)Component.text((String)message).color((TextColor)NamedTextColor.WHITE)).decoration(TextDecoration.BOLD, false)))), false));
        });
        this.override();
    }
}

