/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.game;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.ScoreboardManager;
import java.util.function.Function;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GameActionBar {
    private static BukkitTask task;
    private static int counter;

    public static void enable() {
        task = new BukkitRunnable(){

            public void run() {
                Function<Player, Component> actionbar = player -> switch (GameState.currentGameState) {
                    default -> throw new MatchException(null, null);
                    case GameState.LOBBY -> {
                        if (player.isOp() && counter < 160) {
                            yield (TranslatableComponent)Component.translatable((String)"game.operator").fallback("You are an operator").color((TextColor)NamedTextColor.GRAY);
                        }
                        TranslatableComponent translatableComponent = (TranslatableComponent)Component.translatable((String)"game.waiting.operator").fallback("Waiting for operator").color((TextColor)NamedTextColor.GRAY);
                        if (counter < 20 && counter >= 0 || counter < 100 && counter >= 80) {
                            yield GameActionBar.createComponent((Component)translatableComponent, 1);
                        }
                        if (counter < 40 && counter >= 20 || counter < 120 && counter >= 100) {
                            yield GameActionBar.createComponent((Component)translatableComponent, 2);
                        }
                        if (counter < 60 && counter >= 40 || counter < 140 && counter >= 120) {
                            yield GameActionBar.createComponent((Component)translatableComponent, 3);
                        }
                        if (counter < 80 && counter >= 60 || counter < 160 && counter >= 140) {
                            yield GameActionBar.createComponent((Component)translatableComponent, 4);
                        }
                        yield ScoreboardManager.getAuthor().append(Component.text((String)(" - v" + Main.plugin.getPluginMeta().getVersion())).color((TextColor)NamedTextColor.GRAY));
                    }
                    case GameState.TEAM_SELECT -> {
                        TranslatableComponent translatableComponent = (TranslatableComponent)((TranslatableComponent)Component.translatable((String)(player.isOp() && counter < 160 ? "game.waiting.you" : "game.waiting.start")).fallback(player.isOp() && counter < 160 ? "Waiting for you to start the game" : "Waiting for operator to start the game").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)" "));
                        Component base = Component.text((String)" ").append((Component)translatableComponent);
                        if (counter < 20 && counter >= 0 || counter < 100 && counter >= 80) {
                            yield GameActionBar.createComponent(base, 1);
                        }
                        if (counter < 40 && counter >= 20 || counter < 120 && counter >= 100) {
                            yield GameActionBar.createComponent(base, 2);
                        }
                        if (counter < 60 && counter >= 40 || counter < 140 && counter >= 120) {
                            yield GameActionBar.createComponent(base, 3);
                        }
                        if (counter < 80 && counter >= 60 || counter < 160 && counter >= 140) {
                            yield GameActionBar.createComponent(base, 4);
                        }
                        yield BingoTeam.getTeam(player.getUniqueId()).map(team -> (TranslatableComponent)Component.translatable((String)"team.your", (ComponentLike[])new ComponentLike[]{team.getName()}).fallback("Your are in team " + PlainTextComponentSerializer.plainText().serialize((Component)team.getName())).color((TextColor)NamedTextColor.GRAY)).orElseGet(() -> (TranslatableComponent)Component.translatable((String)"team.choose").fallback("Choose your team").color((TextColor)NamedTextColor.GRAY));
                    }
                    case GameState.STARTING -> Main.bingoPrefixComponent;
                    case GameState.INGAME, GameState.RESTART -> Component.empty();
                    case GameState.FINISH -> {
                        if (GameState.restartTime == -1L) {
                            yield (TranslatableComponent)Component.translatable((String)"deathScreen.title.hardcore").fallback("Game over!").color((TextColor)NamedTextColor.RED);
                        }
                        long seconds = (GameState.restartTime - System.currentTimeMillis()) / 1000L;
                        if (seconds <= 0L) {
                            new BukkitRunnable(this){

                                public void run() {
                                    GameState.setGameState(GameState.RESTART);
                                }
                            }.runTask(Main.plugin);
                            this.cancel();
                        }
                        yield (TranslatableComponent)((TranslatableComponent)Component.translatable((String)"deathScreen.title.hardcore").fallback("Game over!").color((TextColor)NamedTextColor.RED)).append(Component.text((String)" ").append(Component.translatable((String)"game.restart", (ComponentLike[])new ComponentLike[]{Component.text((long)seconds).color((TextColor)NamedTextColor.GRAY)}).fallback("\u00a7cServer restarting in \u00a77" + seconds + "\u00a7c seconds!").color((TextColor)NamedTextColor.RED)));
                    }
                };
                Bukkit.getOnlinePlayers().forEach(player -> player.sendActionBar((Component)actionbar.apply((Player)player)));
                if (++counter >= 260) {
                    counter = 0;
                }
            }
        }.runTaskTimerAsynchronously(Main.plugin, 0L, 1L);
    }

    public static void disable() {
        if (task != null && (Bukkit.getScheduler().isQueued(task.getTaskId()) || Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId()))) {
            task.cancel();
        }
    }

    private static Component createComponent(Component component, int step) {
        return GameActionBar.dots(step, true).append(Component.text((String)" ").append(component.append(Component.text((String)" ").append(GameActionBar.dots(step, false)))));
    }

    private static Component dots(int step, boolean isLeft) {
        Component dotGray = ((TextComponent)Component.text((String)"\u25cf").color((TextColor)NamedTextColor.GRAY)).decorate(TextDecoration.BOLD);
        Component dotDarkGray = ((TextComponent)Component.text((String)"\u25cf").color((TextColor)NamedTextColor.DARK_GRAY)).decorate(TextDecoration.BOLD);
        BuildableComponent left = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(dotGray)).append(dotDarkGray)).append(dotDarkGray)).build();
        BuildableComponent mid = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(dotDarkGray)).append(dotGray)).append(dotDarkGray)).build();
        BuildableComponent right = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(dotDarkGray)).append(dotDarkGray)).append(dotGray)).build();
        return switch (step) {
            case 1 -> {
                if (isLeft) {
                    yield left;
                }
                yield right;
            }
            case 2, 4 -> mid;
            case 3 -> {
                if (isLeft) {
                    yield right;
                }
                yield left;
            }
            default -> Component.empty();
        };
    }

    static {
        counter = 0;
    }
}

