/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.game;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.ServerRestartSetting;
import de.eisi05.bingo.bingo.settings.TimeSetting;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.manager.PlacementManager;
import de.eisi05.bingo.manager.ScoreboardManager;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.RestartFile;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.world.WorldGeneration;
import de.eisi05.bingo.world.WorldManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public enum GameState {
    LOBBY{

        @Override
        public GameState run() {
            return this;
        }
    }
    ,
    TEAM_SELECT{

        @Override
        public GameState run() {
            BingoTeam.createBingoTeams();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.setScoreboard(ScoreboardManager.createScoreboard());
                player.getInventory().setItem(8, BingoUtils.teamSelectItem());
                if (!player.isOp()) continue;
                player.getInventory().setItem(4, BingoUtils.startItem);
            }
            return this;
        }
    }
    ,
    STARTING{

        @Override
        public GameState run() {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.getInventory().clear();
            }
            new BukkitRunnable(this){

                public void run() {
                    Main.plugin.getLogger().info("Calculating objects for the game...");
                    BingoObject.calculateNewSelectedObjects().thenRun(() -> {
                        Bukkit.broadcast((Component)Component.text((String)"\n\n"));
                        Bukkit.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"       --- ").color((TextColor)NamedTextColor.DARK_GRAY))).append(Prefix.SERVER)).append(Component.text((String)"---       ").color((TextColor)NamedTextColor.DARK_GRAY))).build());
                        Arrays.stream(BingoSetting.values()).filter(bingoSetting -> bingoSetting.getSettingsText() != null).sorted((o1, o2) -> {
                            boolean isO1TimeSetting = o1.getClass().equals(TimeSetting.class);
                            boolean isO2TimeSetting = o2.getClass().equals(TimeSetting.class);
                            if (isO1TimeSetting && isO2TimeSetting) {
                                return 0;
                            }
                            if (isO1TimeSetting) {
                                return 1;
                            }
                            if (isO2TimeSetting) {
                                return -1;
                            }
                            boolean isO1Boolean = o1.getDefaultValue().getClass().equals(Boolean.class);
                            boolean isO2Boolean = o2.getDefaultValue().getClass().equals(Boolean.class);
                            if (isO1Boolean && isO2Boolean) {
                                return 0;
                            }
                            if (isO1Boolean) {
                                return -1;
                            }
                            if (isO2Boolean) {
                                return 1;
                            }
                            return 0;
                        }).forEach(bingoSetting -> Bukkit.broadcast((Component)bingoSetting.getSettingsText()));
                    });
                    Main.plugin.getLogger().info("Calculating done!");
                }
            }.runTaskLaterAsynchronously(Main.plugin, 10L);
            new BukkitRunnable(this){
                final int startCounter = 15;
                int counter = 15;

                public void run() {
                    Bukkit.getOnlinePlayers().forEach(player -> {
                        player.setLevel(this.counter);
                        player.setExp((float)this.counter / 15.0f);
                    });
                    if (this.counter <= 0) {
                        this.cancel();
                        GameState.setGameState(INGAME);
                        for (Player player2 : Bukkit.getOnlinePlayers()) {
                            BingoUtils.sendTitle((HumanEntity)player2, Component.translatable((String)"game.time.go", (String)"GO!").color((TextColor)NamedTextColor.DARK_GREEN), (Component)Component.empty(), 0L, 50L, 0L);
                            player2.playSound((Entity)player2, Sound.ENTITY_ENDER_DRAGON_GROWL, 100.0f, 1.0f);
                        }
                    } else if (this.counter == 15 || this.counter == 10 || this.counter <= 5) {
                        NamedTextColor color = switch (this.counter) {
                            case 5 -> NamedTextColor.DARK_RED;
                            case 4 -> NamedTextColor.RED;
                            case 3 -> NamedTextColor.GOLD;
                            case 2 -> NamedTextColor.YELLOW;
                            case 1 -> NamedTextColor.GREEN;
                            default -> NamedTextColor.BLUE;
                        };
                        Component message = Component.translatable((String)"game.time.start.chat", (String)LegacyComponentSerializer.legacySection().serialize(((TextComponent)Component.text((String)"Game will start in ").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)Component.text((int)this.counter).color((TextColor)color)).append(Component.text((String)" second(s)!").color((TextColor)NamedTextColor.GRAY)))), (ComponentLike[])new ComponentLike[]{Component.text((int)this.counter).color((TextColor)color)}).color((TextColor)NamedTextColor.GRAY);
                        for (Player player3 : Bukkit.getOnlinePlayers()) {
                            BingoUtils.sendMessage((HumanEntity)player3, message, true);
                            player3.playSound(player3.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 100.0f, 1.0f);
                            if (this.counter > 5 || this.counter <= 0) continue;
                            BingoUtils.sendTitle((HumanEntity)player3, Component.translatable((String)"game.time.start.title", (String)"Game starts in").color((TextColor)NamedTextColor.GRAY), Component.text((String)String.valueOf(this.counter)).color((TextColor)color), 0L, 50L, 0L);
                        }
                    }
                    --this.counter;
                }
            }.runTaskTimer(Main.plugin, 0L, 20L);
            return this;
        }
    }
    ,
    INGAME{

        @Override
        public GameState run() {
            TranslatableComponent translatableComponent = (TranslatableComponent)Component.translatable((String)"selectWorld.commands").fallback("Commands").color((TextColor)NamedTextColor.GRAY);
            Component baseComponent = ((TextComponent)((TextComponent)Component.newline().appendNewline()).append(Prefix.SERVER)).append(Component.text((String)" --- ").color((TextColor)NamedTextColor.DARK_GRAY));
            Component endComponent = Component.text((String)" ---").color((TextColor)NamedTextColor.DARK_GRAY);
            Bukkit.broadcast((Component)baseComponent.append(translatableComponent.append(endComponent)));
            AbstractCommand.getCommands().forEach(abstractCommand -> {
                MutableComponent component = net.minecraft.network.chat.Component.literal((String)("/" + abstractCommand.getName() + (String)(abstractCommand.getAliases().length > 0 ? " | " + String.join((CharSequence)" | ", abstractCommand.getAliases()) : ""))).withStyle(ChatFormatting.GRAY).append((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.literal((String)" >> ").withStyle(ChatFormatting.DARK_GRAY).append((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.translatableWithFallback((String)abstractCommand.getDescriptionKey(), (String)abstractCommand.getFallback()).withStyle(ChatFormatting.GREEN)));
                ((CraftServer)Bukkit.getServer()).getHandle().broadcastMessage(new net.minecraft.network.chat.Component[]{component});
            });
            time = (Integer)BingoSetting.getSetting(TimeSetting.class).getValue() == 0 ? System.currentTimeMillis() : System.currentTimeMillis() + (long)((Integer)BingoSetting.getSetting(TimeSetting.class).getValue() * 60 * 1000);
            BingoTeam.teams.removeIf(team -> team.getPlayers().isEmpty());
            WorldGeneration.removeWalls(WorldManager.overworld);
            WorldManager.overworld.setDifficulty(Difficulty.NORMAL);
            WorldManager.overworld.setTime(1200L);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.addAttachment(Main.plugin, "bingo", true);
                player.recalculatePermissions();
                player.updateCommands();
                ScoreboardManager.updateScoreboard(player);
                if (BingoTeam.getTeam(player.getUniqueId()).isEmpty()) {
                    player.setGameMode(GameMode.SPECTATOR);
                    BingoTeam.addPlayerToSpectator((HumanEntity)player);
                } else {
                    player.setGameMode(GameMode.SURVIVAL);
                }
                player.getInventory().clear();
                player.setHealth(20.0);
                player.setLevel(0);
                player.setExp(0.0f);
                player.setSaturation(10.0f);
                player.setFoodLevel(20);
            }
            task = new BukkitRunnable(this){

                public void run() {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        ScoreboardManager.updateTime(player);
                    }
                    if ((Integer)BingoSetting.getSetting(TimeSetting.class).getValue() != 0 && time - System.currentTimeMillis() <= 0L) {
                        GameState.setGameState(FINISH);
                        this.cancel();
                    }
                    BingoTeam.teams.forEach(BingoTeam::updateAdvancementProgresses);
                }
            }.runTaskTimer(Main.plugin, 0L, 1L);
            return this;
        }
    }
    ,
    FINISH{

        @Override
        public GameState run() {
            if (task != null && !task.isCancelled() && (Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId()) || Bukkit.getScheduler().isQueued(task.getTaskId()))) {
                task.cancel();
            }
            List<BingoTeam> winner = PlacementManager.getFirstPlace();
            Component winnerTeams = Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), winner.stream().map(team -> (TextComponent)team.getName().color((TextColor)NamedTextColor.GRAY)).toList());
            Component prefix = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.newline().appendNewline()).appendNewline()).appendNewline()).appendNewline()).append(Prefix.SERVER);
            TextComponent winnerTeamsComponent = null;
            for (int i = 0; i < winner.size(); ++i) {
                BingoTeam bingoTeam = winner.get(i);
                TextComponent team2 = (TextComponent)bingoTeam.getName().hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), bingoTeam.getPlayers().stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).filter(Objects::nonNull).map(name -> (TextComponent)Component.text((String)name).color((TextColor)bingoTeam.getColor())).toList())));
                if (i + 1 != winner.size()) {
                    team2 = (TextComponent)team2.append(Component.text((String)", ").color((TextColor)NamedTextColor.GRAY));
                }
                winnerTeamsComponent = winnerTeamsComponent == null ? team2 : (TextComponent)winnerTeamsComponent.append((Component)team2);
            }
            TranslatableComponent winnerComponent = (TranslatableComponent)Component.translatable((String)"game.won", (ComponentLike[])new ComponentLike[]{winnerTeamsComponent}).fallback(LegacyComponentSerializer.legacySection().serialize(winnerTeamsComponent) + " \u00a76won the game!").color((TextColor)NamedTextColor.GOLD);
            prefix = prefix.append((Component)winnerComponent);
            Component seedPrefix = Component.newline().append(Prefix.SERVER);
            TranslatableComponent seed = (TranslatableComponent)((TranslatableComponent)Component.translatable((String)"commands.seed.success", (ComponentLike[])new ComponentLike[]{Component.text((long)WorldManager.overworld.getSeed())}).fallback("Seed: " + WorldManager.overworld.getSeed()).color((TextColor)NamedTextColor.GREEN)).clickEvent(ClickEvent.copyToClipboard((String)String.valueOf(WorldManager.overworld.getSeed())));
            TextComponent seedSuffix = Component.newline();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(prefix.append(seedPrefix).append((Component)seed).append((Component)seedSuffix));
                player.playSound((Entity)player, Sound.UI_TOAST_CHALLENGE_COMPLETE, 100.0f, 1.0f);
                if (winner.stream().anyMatch(team -> team.getPlayers().contains(player.getUniqueId()))) {
                    BingoUtils.sendTitle((HumanEntity)player, Component.translatable((String)"game.you.won", (String)"You won!").color((TextColor)NamedTextColor.GOLD), Component.translatable((String)"game.congratulations", (String)"Congratulations!").color((TextColor)NamedTextColor.GREEN), 20L, 500L, 20L);
                    continue;
                }
                BingoUtils.sendTitle((HumanEntity)player, Component.translatable((String)"deathScreen.title.hardcore", (String)"Game Over!").color((TextColor)NamedTextColor.RED), Component.translatable((String)"game.won", (String)(LegacyComponentSerializer.legacySection().serialize(winnerTeams) + " won the game!"), (ComponentLike[])new ComponentLike[]{winnerTeams}).color((TextColor)NamedTextColor.GOLD), 5L, 500L, 5L);
            }
            restartTime = (Integer)BingoSetting.getSetting(ServerRestartSetting.class).getValue() == 0 ? -1L : System.currentTimeMillis() + (long)((Integer)BingoSetting.getSetting(ServerRestartSetting.class).getValue() * 1000);
            return this;
        }
    }
    ,
    RESTART{

        @Override
        public GameState run() {
            Bukkit.getOnlinePlayers().forEach(player -> ((CraftPlayer)player).getHandle().connection.disconnect(Component.translatable((String)"game.restart.title").fallback("Server Restart & World Reset!").color((TextColor)NamedTextColor.RED)));
            RestartFile.create();
            Bukkit.getScheduler().scheduleSyncDelayedTask(Main.plugin, () -> Bukkit.getServer().restart(), 5L);
            return this;
        }
    };

    public static GameState currentGameState;
    public static long time;
    public static long restartTime;
    private static BukkitTask task;

    public static void setGameState(GameState gameState) {
        currentGameState = gameState.run();
    }

    public abstract GameState run();

    static {
        currentGameState = LOBBY.run();
    }
}

