/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.libs.commandapi;

import de.eisi05.bingo.libs.commandapi.Executable;
import de.eisi05.bingo.libs.commandapi.Execution;
import de.eisi05.bingo.libs.commandapi.arguments.AbstractArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractArgumentTree<Impl extends AbstractArgumentTree<Impl, Argument, CommandSender>, Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender>
extends Executable<Impl, CommandSender> {
    final List<AbstractArgumentTree<?, Argument, CommandSender>> arguments = new ArrayList();
    final Argument argument;

    protected AbstractArgumentTree() {
        if (!(this instanceof AbstractArgument)) {
            throw new IllegalArgumentException("Implicit inherited constructor must be from Argument");
        }
        this.argument = (AbstractArgument)this;
    }

    protected AbstractArgumentTree(Argument argument) {
        this.argument = argument;
        this.executor = ((AbstractArgument)argument).executor;
    }

    public Impl then(AbstractArgumentTree<?, Argument, CommandSender> tree) {
        this.arguments.add(tree);
        return (Impl)((AbstractArgumentTree)this.instance());
    }

    public final Impl thenNested(List<AbstractArgumentTree<?, Argument, CommandSender>> trees) {
        int length = trees.size();
        if (length == 0) {
            return (Impl)((AbstractArgumentTree)this.instance());
        }
        AbstractArgumentTree<Object, Argument, CommandSender> combined = trees.get(length - 1);
        for (int i = length - 2; i >= 0; --i) {
            combined = trees.get(i).then(combined);
        }
        return this.then(combined);
    }

    @SafeVarargs
    public final Impl thenNested(AbstractArgumentTree<?, Argument, CommandSender> ... trees) {
        return this.thenNested(Arrays.asList(trees));
    }

    List<Execution<CommandSender, Argument>> getExecutions() {
        ArrayList<Execution<CommandSender, Argument>> executions = new ArrayList<Execution<CommandSender, Argument>>();
        if (this.executor.hasAnyExecutors()) {
            executions.add(new Execution(List.of(this.argument), this.executor));
        }
        for (AbstractArgumentTree<?, Argument, CommandSender> tree : this.arguments) {
            for (Execution<CommandSender, Argument> execution : tree.getExecutions()) {
                executions.add(execution.prependedBy(this.argument));
            }
        }
        return executions;
    }
}

