/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.libs.commandapi.exceptions;

public class ProtocolVersionTooOldException
extends RuntimeException {
    private final String reason;
    private final int protocolVersion;

    public static ProtocolVersionTooOldException whileSending(Object target, int protocolVersion, String reason) {
        return new ProtocolVersionTooOldException("Tried to send a packet to " + String.valueOf(target) + ", which is using protocol version " + protocolVersion + ". This system is using version 1. That version is too old to receive the packet. " + reason, protocolVersion, reason);
    }

    public static ProtocolVersionTooOldException received(Object sender, int protocolVersion, String reason) {
        return new ProtocolVersionTooOldException(String.valueOf(sender) + " tried to send a packet here using protocol version " + protocolVersion + ". This system is using version 1. This version is too old to receive the packet. " + reason, protocolVersion, reason);
    }

    private ProtocolVersionTooOldException(String message, int protocolVersion, String reason) {
        super(message);
        this.reason = reason;
        this.protocolVersion = protocolVersion;
    }

    public String getReason() {
        return this.reason;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }
}

