/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.libs.commandapi.executors;

import de.eisi05.bingo.libs.commandapi.arguments.AbstractArgument;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public record CommandArguments(Object[] args, Map<String, Object> argsMap, String[] rawArgs, Map<String, String> rawArgsMap, String fullInput) {
    private final Map<String, Object> argsMap;
    private final Map<String, String> rawArgsMap;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = Map.of(Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);

    public Map<String, Object> argsMap() {
        return Collections.unmodifiableMap(this.argsMap);
    }

    public Map<String, String> rawArgsMap() {
        return Collections.unmodifiableMap(this.rawArgsMap);
    }

    public int count() {
        return this.args.length;
    }

    @Nullable
    public Object get(int index) {
        if (this.args.length <= index) {
            return null;
        }
        return this.args[index];
    }

    @Nullable
    public Object get(String nodeName) {
        return this.argsMap.get(nodeName);
    }

    public Object getOrDefault(int index, Object defaultValue) {
        if (this.args.length <= index) {
            return defaultValue;
        }
        return this.args[index];
    }

    public Object getOrDefault(String nodeName, Object defaultValue) {
        return this.argsMap.getOrDefault(nodeName, defaultValue);
    }

    public Object getOrDefault(int index, Supplier<?> defaultValue) {
        if (this.args.length <= index) {
            return defaultValue.get();
        }
        return this.args[index];
    }

    public Object getOrDefault(String nodeName, Supplier<?> defaultValue) {
        return this.argsMap.getOrDefault(nodeName, defaultValue.get());
    }

    public Optional<Object> getOptional(int index) {
        if (this.args.length <= index) {
            return Optional.empty();
        }
        return Optional.of(this.args[index]);
    }

    public Optional<Object> getOptional(String nodeName) {
        if (!this.argsMap.containsKey(nodeName)) {
            return Optional.empty();
        }
        return Optional.of(this.argsMap.get(nodeName));
    }

    @Nullable
    public String getRaw(int index) {
        if (this.rawArgs.length <= index) {
            return null;
        }
        return this.rawArgs[index];
    }

    @Nullable
    public String getRaw(String nodeName) {
        return this.rawArgsMap.get(nodeName);
    }

    public String getOrDefaultRaw(int index, String defaultValue) {
        if (this.rawArgs.length <= index) {
            return defaultValue;
        }
        return this.rawArgs[index];
    }

    public String getOrDefaultRaw(String nodeName, String defaultValue) {
        return this.rawArgsMap.getOrDefault(nodeName, defaultValue);
    }

    public String getOrDefaultRaw(int index, Supplier<String> defaultValue) {
        if (this.rawArgs.length <= index) {
            return defaultValue.get();
        }
        return this.rawArgs[index];
    }

    public String getOrDefaultRaw(String nodeName, Supplier<String> defaultValue) {
        return this.rawArgsMap.getOrDefault(nodeName, defaultValue.get());
    }

    public Optional<String> getRawOptional(int index) {
        if (this.rawArgs.length <= index) {
            return Optional.empty();
        }
        return Optional.of(this.rawArgs[index]);
    }

    public Optional<String> getRawOptional(String nodeName) {
        if (!this.rawArgsMap.containsKey(nodeName)) {
            return Optional.empty();
        }
        return Optional.of(this.rawArgsMap.get(nodeName));
    }

    @Nullable
    public <T> T getUnchecked(int index) {
        return (T)this.get(index);
    }

    @Nullable
    public <T> T getUnchecked(String nodeName) {
        return (T)this.get(nodeName);
    }

    public <T> T getOrDefaultUnchecked(int index, T defaultValue) {
        return (T)this.getOrDefault(index, defaultValue);
    }

    public <T> T getOrDefaultUnchecked(String nodeName, T defaultValue) {
        return (T)this.getOrDefault(nodeName, defaultValue);
    }

    public <T> T getOrDefaultUnchecked(int index, Supplier<T> defaultValue) {
        return (T)this.getOrDefault(index, defaultValue);
    }

    public <T> T getOrDefaultUnchecked(String nodeName, Supplier<T> defaultValue) {
        return (T)this.getOrDefault(nodeName, defaultValue);
    }

    public <T> Optional<T> getOptionalUnchecked(int index) {
        return this.getOptional(index);
    }

    public <T> Optional<T> getOptionalUnchecked(String nodeName) {
        return this.getOptional(nodeName);
    }

    @Nullable
    public <T> T getByArgument(AbstractArgument<T, ?, ?, ?> argumentType) {
        return this.castArgument(this.get(argumentType.getNodeName()), argumentType.getPrimitiveType(), argumentType.getNodeName());
    }

    public <T> T getByArgumentOrDefault(AbstractArgument<T, ?, ?, ?> argumentType, T defaultValue) {
        T argument = this.getByArgument(argumentType);
        return argument != null ? argument : defaultValue;
    }

    public <T> Optional<T> getOptionalByArgument(AbstractArgument<T, ?, ?, ?> argumentType) {
        return Optional.ofNullable(this.getByArgument(argumentType));
    }

    @Nullable
    public <T> T getByClass(String nodeName, Class<T> argumentType) {
        return this.castArgument(this.get(nodeName), argumentType, nodeName);
    }

    public <T> T getByClassOrDefault(String nodeName, Class<T> argumentType, T defaultValue) {
        T argument = this.getByClass(nodeName, argumentType);
        return argument != null ? argument : defaultValue;
    }

    public <T> Optional<T> getOptionalByClass(String nodeName, Class<T> argumentType) {
        return Optional.ofNullable(this.getByClass(nodeName, argumentType));
    }

    @Nullable
    public <T> T getByClass(int index, Class<T> argumentType) {
        return this.castArgument(this.get(index), argumentType, index);
    }

    public <T> T getByClassOrDefault(int index, Class<T> argumentType, T defaultValue) {
        T argument = this.getByClass(index, argumentType);
        return argument != null ? argument : defaultValue;
    }

    public <T> Optional<T> getOptionalByClass(int index, Class<T> argumentType) {
        return Optional.ofNullable(this.getByClass(index, argumentType));
    }

    private <T> T castArgument(Object argument, Class<T> argumentType, Object argumentNameOrIndex) {
        if (argument == null) {
            return null;
        }
        if (!PRIMITIVE_TO_WRAPPER.getOrDefault(argumentType, argumentType).isAssignableFrom(argument.getClass())) {
            throw new IllegalArgumentException(this.buildExceptionMessage(argumentNameOrIndex, argument.getClass().getSimpleName(), argumentType.getSimpleName()));
        }
        return (T)argument;
    }

    private String buildExceptionMessage(Object argumentNameOrIndex, String expectedClass, String actualClass) {
        if (argumentNameOrIndex instanceof Integer) {
            Integer i = (Integer)argumentNameOrIndex;
            return "Argument at index '" + i + "' is defined as " + expectedClass + ", not " + actualClass;
        }
        if (argumentNameOrIndex instanceof String) {
            String s = (String)argumentNameOrIndex;
            return "Argument '" + s + "' is defined as " + expectedClass + ", not " + actualClass;
        }
        throw new IllegalStateException("Unexpected behaviour detected while building exception message!This should never happen - if you're seeing this message, pleasecontact the developers of the CommandAPI, we'd love to know how you managed to get this error!");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode(this.args);
        result = 31 * result + Arrays.hashCode(this.rawArgs);
        result = 31 * result + Objects.hash(this.argsMap, this.fullInput, this.rawArgsMap);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommandArguments other = (CommandArguments)obj;
        return Arrays.deepEquals(this.args, other.args) && Objects.equals(this.argsMap, other.argsMap) && Objects.equals(this.fullInput, other.fullInput) && Arrays.equals(this.rawArgs, other.rawArgs) && Objects.equals(this.rawArgsMap, other.rawArgsMap);
    }
}

