/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.listener.CollectListener;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.world.WorldManager;
import io.papermc.paper.advancement.PaperAdvancementDisplay;
import java.lang.reflect.Field;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import org.bukkit.GameRule;
import org.bukkit.craftbukkit.advancement.CraftAdvancement;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;

public class CollectAdvancementListener
implements CollectListener<org.bukkit.advancement.Advancement> {
    @EventHandler
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        if (event.getAdvancement().getDisplay() == null) {
            return;
        }
        Advancement advancement = ((CraftAdvancement)event.getAdvancement()).getHandle().value();
        if (advancement.isRoot()) {
            return;
        }
        DisplayInfo displayInfo = ((PaperAdvancementDisplay)event.getAdvancement().getDisplay()).handle();
        try {
            Field showToast = displayInfo.getClass().getDeclaredField("showToast");
            showToast.setAccessible(true);
            showToast.set(displayInfo, false);
            Field announce = displayInfo.getClass().getDeclaredField("announceChat");
            announce.setAccessible(true);
            announce.set(displayInfo, false);
        }
        catch (Exception showToast) {
            // empty catch block
        }
        NamedTextColor color = switch (displayInfo.getType()) {
            default -> throw new MatchException(null, null);
            case AdvancementType.CHALLENGE -> NamedTextColor.DARK_PURPLE;
            case AdvancementType.GOAL, AdvancementType.TASK -> NamedTextColor.GREEN;
        };
        TranslatableComponent translatableComponent = (TranslatableComponent)Component.translatable((String)"telemetry.event.advancement_made.title").fallback("Advancement Made").color((TextColor)NamedTextColor.GRAY);
        TranslatableComponent advancementText = ((TranslatableComponent)Component.translatable((String)("advancements." + event.getAdvancement().getKey().getKey().replace("/", ".") + ".title")).color((TextColor)color)).fallback(PlainTextComponentSerializer.plainText().serialize(event.getAdvancement().getDisplay().title()));
        TranslatableComponent description = ((TranslatableComponent)Component.translatable((String)("advancements." + event.getAdvancement().getKey().getKey().replace("/", ".") + ".description")).color((TextColor)NamedTextColor.GRAY)).fallback(PlainTextComponentSerializer.plainText().serialize(event.getAdvancement().getDisplay().description()));
        advancementText = (TranslatableComponent)advancementText.hoverEvent((HoverEventSource)HoverEvent.showText((Component)advancementText.append(Component.newline().append((Component)description))));
        Component component = Component.text((String)": ").color((TextColor)NamedTextColor.GRAY);
        if (((Boolean)WorldManager.overworld.getGameRuleValue(GameRule.ANNOUNCE_ADVANCEMENTS)).booleanValue()) {
            event.getPlayer().sendMessage(Prefix.SERVER.append(((TranslatableComponent)translatableComponent.append(component)).append((Component)advancementText)));
        }
        this.collect(event.getAdvancement(), event.getPlayer());
    }
}

