/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.ScoreboardManager;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.toast.AdvancementFrame;
import de.eisi05.bingo.utils.eisutils.toast.ToastNotification;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public interface CollectListener<T>
extends Listener {
    default public void collect(T object, Player player) {
        if (GameState.currentGameState != GameState.INGAME) {
            return;
        }
        BingoTeam.getTeam(player.getUniqueId()).ifPresent(team -> {
            for (BingoObject missing : team.getMissingBingoItems().stream().filter(bingoObject -> bingoObject.getObjectClass().isAssignableFrom(object.getClass())).map(bingoObject -> bingoObject).toList()) {
                if (!missing.isSimilarObject(object)) continue;
                team.foundBingoItem(missing);
                Component message = Prefix.SERVER.append(Component.text((String)player.getName()).color((TextColor)NamedTextColor.GREEN)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY)).append(team.getName().color((TextColor)team.getColor())).append(Component.text((String)") ").color((TextColor)NamedTextColor.GRAY)).append(missing.getFoundVerb().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)" ")).append(missing.getName().color((TextColor)NamedTextColor.BLUE)).append(Component.text((String)" (").color((TextColor)NamedTextColor.DARK_GRAY)).append(((TextComponent)Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team.getMissingBingoItems().size())).color((TextColor)NamedTextColor.RED)).decoration(TextDecoration.BOLD, true)).append(Component.text((String)"/").color((TextColor)NamedTextColor.DARK_GRAY)).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)")").color((TextColor)NamedTextColor.DARK_GRAY));
                Bukkit.broadcast((Component)message);
                ToastNotification toast = new ToastNotification(missing.asDisplayIcon(), missing.getName().color((TextColor)NamedTextColor.BLUE).append(Component.text((String)" ").append(missing.getFoundVerb().color((TextColor)NamedTextColor.GRAY))), AdvancementFrame.TASK);
                team.getPlayers().stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).forEach(player1 -> {
                    toast.send(player1.getPlayer());
                    player1.getPlayer().playSound((Entity)player1.getPlayer(), Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                    if (player1.getPlayer().getOpenInventory().getTopInventory().getHolder() instanceof BingoTeam.BingoTeamInventoryHolder) {
                        player1.getPlayer().performCommand("bingo");
                    }
                });
                for (Player online : Bukkit.getOnlinePlayers()) {
                    ScoreboardManager.updateScoreboard(online);
                }
                if (!team.getMissingBingoItems().isEmpty()) break;
                GameState.setGameState(GameState.FINISH);
                break;
            }
        });
    }
}

