/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.DamageSetting;
import de.eisi05.bingo.bingo.settings.EndSetting;
import de.eisi05.bingo.bingo.settings.KeepInventorySetting;
import de.eisi05.bingo.bingo.settings.NetherSetting;
import de.eisi05.bingo.bingo.settings.PVPSetting;
import de.eisi05.bingo.bingo.settings.RandomizerSetting;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.RandomizeManager;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.config.ItemConfiguration;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public class GameListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
            return;
        }
        if (((Boolean)BingoSetting.getSetting(RandomizerSetting.class).getValue()).booleanValue()) {
            event.setDropItems(false);
            RandomizeManager.getItems(event.getBlock().getType()).forEach(material -> event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), new ItemStack(material)));
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getDamageSource().getCausingEntity() instanceof Player) {
            return;
        }
        if (!((Boolean)BingoSetting.getSetting(DamageSetting.class).getValue()).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!((Boolean)BingoSetting.getSetting(DamageSetting.class).getValue()).booleanValue() && !(event.getDamager() instanceof Player)) {
            event.setCancelled(true);
        }
        if (!((Boolean)BingoSetting.getSetting(PVPSetting.class).getValue()).booleanValue() && event.getDamager() instanceof Player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortal(PlayerPortalEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && !((Boolean)BingoSetting.getSetting(EndSetting.class).getValue()).booleanValue()) {
            event.setCancelled(true);
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL && !((Boolean)BingoSetting.getSetting(NetherSetting.class).getValue()).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Component message = event.deathMessage();
        List list = message.children();
        if (list instanceof TranslatableComponent) {
            TranslatableComponent translatableContents = (TranslatableComponent)list;
            Component prefix = ((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.DARK_GRAY)).append(Main.bingoPrefixComponent.append(Component.text((String)"] ").color((TextColor)NamedTextColor.DARK_GRAY)));
            Component playerName = ((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.GRAY)).append(BingoTeam.getTeam(event.getEntity().getUniqueId()).map(bingoTeam -> bingoTeam.getName()).orElse(Component.translatable((String)"game.Spectator", (String)"Spectator").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"] ")).append(event.getEntity().displayName().color((TextColor)BingoTeam.getTeam(event.getEntity().getUniqueId()).map(BingoTeam::getColor).orElse(NamedTextColor.GRAY))).color((TextColor)NamedTextColor.GRAY));
            TranslationArgument mutableComponent = (TranslationArgument)translatableContents.arguments().getFirst();
            Component finalMessage = (translatableContents.arguments().size() == 1 ? Component.translatable((String)translatableContents.key()).arguments(new ComponentLike[]{playerName.append((ComponentLike)mutableComponent)}) : Component.translatable((String)translatableContents.key()).arguments(Stream.concat(Stream.of(playerName), translatableContents.arguments().subList(1, translatableContents.arguments().size()).stream()).toList().toArray(new ComponentLike[0]))).color((TextColor)NamedTextColor.GRAY);
            event.deathMessage(prefix.append(finalMessage));
        } else {
            Component deathMessage = event.deathMessage();
            String playerName = event.getEntity().getName();
            String teamName = BingoTeam.getTeam(event.getEntity().getUniqueId()).map(BingoTeam::getNameAsString).orElse("Spectator");
            Component prefix = Prefix.SERVER;
            Component teamPrefix = ((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)teamName, (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.GRAY));
            TextComponent nameComponent = Component.text((String)playerName);
            Component replacement = teamPrefix.append((Component)nameComponent).append((Component)Component.text((String)"", (TextColor)NamedTextColor.GRAY));
            Component finalMessage = prefix.append(deathMessage.replaceText(builder -> builder.matchLiteral(playerName).replacement((ComponentLike)replacement)));
            event.deathMessage(finalMessage);
        }
        event.setKeepInventory(((Boolean)BingoSetting.getSetting(KeepInventorySetting.class).getValue()).booleanValue());
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().startsWith("/teammsg")) {
            event.setMessage("/teamchat" + event.getMessage().substring("/teammsg".length()));
        }
    }

    @EventHandler
    public void onInv(InventoryClickEvent event) {
        if (GameState.currentGameState.ordinal() >= GameState.INGAME.ordinal()) {
            return;
        }
        if (event.getSlot() < 0) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        ItemStack current = null;
        if (event.getCurrentItem() != null) {
            current = event.getCurrentItem();
        }
        if (event.getHotbarButton() != -1) {
            current = event.getClickedInventory().getItem(event.getHotbarButton());
        }
        if (current == null) {
            return;
        }
        ItemConfiguration itemConfiguration = new ItemConfiguration(current);
        if (!itemConfiguration.hasData("id")) {
            return;
        }
        String id1 = (String)new ItemConfiguration(BingoUtils.settingItem).getData("id");
        String id2 = (String)new ItemConfiguration(BingoUtils.startItem).getData("id");
        String id3 = (String)new ItemConfiguration(BingoUtils.teamSelectItem()).getData("id");
        if (((String)itemConfiguration.getData("id")).equals(id1) || ((String)itemConfiguration.getData("id")).equals(id2) || ((String)itemConfiguration.getData("id")).equals(id3)) {
            event.setCancelled(true);
        }
    }
}

