/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.manager;

import de.eisi05.bingo.bingo.BingoTeam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;

public class PlacementManager {
    public static List<BingoTeam> getFirstPlace() {
        return PlacementManager.getMap().firstEntry().getValue();
    }

    public static Component getPlace(BingoTeam team) {
        TreeMap<Integer, List<BingoTeam>> map = PlacementManager.getMap();
        int index = map.entrySet().stream().filter(integerListEntry -> ((List)integerListEntry.getValue()).contains(team)).map(Map.Entry::getKey).findFirst().orElse(-1);
        if (index == -1) {
            return Component.text((String)"?");
        }
        int place = (map.containsKey(index) ? map.headMap(index).size() : -1) + 1;
        String placeString = String.valueOf(place);
        String string = "game.placement." + placeString;
        return Component.translatable((String)string, (String)(switch (place) {
            case 1 -> placeString + "st";
            case 2 -> placeString + "nd";
            case 3 -> placeString + "rd";
            default -> placeString + "th";
        }));
    }

    private static TreeMap<Integer, List<BingoTeam>> getMap() {
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (BingoTeam team : BingoTeam.getSortedTeams()) {
            List current = map.getOrDefault(team.getMissingBingoItems().size(), new ArrayList());
            current.add(team);
            map.put(team.getMissingBingoItems().size(), current);
        }
        TreeMap<Integer, List<BingoTeam>> tree = new TreeMap<Integer, List<BingoTeam>>(Comparator.comparingInt(value -> value));
        tree.putAll(map);
        return tree;
    }
}

