/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.manager;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.TimeSetting;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.listener.ResourcepackListener;
import de.eisi05.bingo.manager.PlacementManager;
import de.eisi05.bingo.utils.eisutils.builder.NMSScoreboardBuilder;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardManager {
    public static Scoreboard createScoreboard() {
        NMSScoreboardBuilder builder = new NMSScoreboardBuilder((Component)Component.empty(), null, Criteria.DUMMY);
        builder.addTeam("Spectator", "team0", ((TextComponent)((TextComponent)Component.text((String)"[").append((Component)Component.translatable((String)"game.spectator", (String)"Spectator"))).append((Component)Component.text((String)"] "))).color((TextColor)NamedTextColor.GRAY), (Component)Component.empty(), NamedTextColor.GRAY);
        for (BingoTeam team : BingoTeam.teams) {
            builder.addTeam(team.getNameAsString(), "team" + team.getId(), ((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.GRAY)).append(((TextComponent)team.getName().color((TextColor)team.getColor())).append(Component.text((String)"] ").color((TextColor)NamedTextColor.GRAY))), (Component)Component.empty(), team.getColor());
            team.getPlayers().forEach(uuid -> builder.addPlayerToTeam(Bukkit.getOfflinePlayer((UUID)uuid), team.getNameAsString()));
        }
        for (NMSScoreboardBuilder.ScoreboardEntry entry : NMSScoreboardBuilder.ScoreboardEntry.values()) {
            builder.addScore(entry, (Component)Component.empty(), (Component)Component.empty());
        }
        return builder.build();
    }

    public static void updateScoreboard(Player player) {
        NMSScoreboardBuilder builder = new NMSScoreboardBuilder(player).setDisplaySlot(DisplaySlot.SIDEBAR);
        List<TextComponent> firstList = PlacementManager.getFirstPlace().stream().map(BingoTeam::getName).toList();
        TextComponent first = Component.empty();
        if (firstList.size() > 5) {
            for (i = 0; i < 5; ++i) {
                first = first.append((Component)firstList.get(i)).append((Component)Component.text((String)", "));
            }
            first = first.append((Component)Component.text((String)"...")).color((TextColor)NamedTextColor.GRAY);
        } else {
            for (i = 0; i < firstList.size(); ++i) {
                first = first.append((Component)firstList.get(i));
                if (i == firstList.size() - 1) continue;
                first = first.append((Component)Component.text((String)", "));
            }
        }
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._15, ((TranslatableComponent)Component.translatable((String)"game.placement.1", (String)"1st").append((Component)Component.text((String)": "))).color((TextColor)NamedTextColor.GOLD), (Component)first);
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._14, ((TranslatableComponent)Component.translatable((String)"game.placement.title", (String)"Placement").append((Component)Component.text((String)": "))).color((TextColor)NamedTextColor.GRAY), BingoTeam.getTeam(player.getUniqueId()).map(PlacementManager::getPlace).orElse((Component)Component.text((String)"?")).color((TextColor)NamedTextColor.GREEN));
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._13, (Component)Component.empty(), (Component)Component.empty());
        if (BingoTeam.getTeam(player.getUniqueId()).isPresent()) {
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._12, ((TranslatableComponent)Component.translatable((String)"game.objects.title", (String)"Objects").append((Component)Component.text((String)" "))).color((TextColor)NamedTextColor.BLUE), ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"(").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)("" + (BingoObject.getSelectedObjects().size() - BingoTeam.getTeam(player.getUniqueId()).map(team -> team.getMissingBingoItems().size()).orElse(BingoObject.getSelectedObjects().size())))).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY)));
            Component item1 = ScoreboardManager.getItem(player, 0);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._11, (Component)(item1.equals((Object)Component.empty()) ? Component.empty() : ScoreboardManager.getBingoObjectSymbol(player, 0)), item1);
            Component item2 = ScoreboardManager.getItem(player, 1);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._10, (Component)(item2.equals((Object)Component.empty()) ? Component.empty() : ScoreboardManager.getBingoObjectSymbol(player, 1)), item2);
            Component item3 = ScoreboardManager.getItem(player, 2);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._9, (Component)(item3.equals((Object)Component.empty()) ? Component.empty() : ScoreboardManager.getBingoObjectSymbol(player, 2)), item3);
            Component item4 = ScoreboardManager.getItem(player, 3);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._8, (Component)(item4.equals((Object)Component.empty()) ? Component.empty() : ScoreboardManager.getBingoObjectSymbol(player, 3)), item4);
            Component item5 = ScoreboardManager.getItem(player, 4);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._7, (Component)(item5.equals((Object)Component.empty()) ? Component.empty() : ScoreboardManager.getBingoObjectSymbol(player, 4)), item5);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._6, (Component)Component.empty(), (Component)Component.empty());
            int more = BingoTeam.getTeam(player.getUniqueId()).map(team -> team.getMissingBingoItems().size() - 5).orElse(0);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._5, (Component)(more <= 0 ? Component.empty() : Component.translatable((String)"game.objects.more", (String)("and " + more + " Objects more"), (ComponentLike[])new ComponentLike[]{Component.text((int)more)}).color((TextColor)NamedTextColor.DARK_GRAY)), (Component)Component.empty());
        } else {
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._12, Component.translatable((String)"game.teams.title", (String)"Teams").color((TextColor)NamedTextColor.BLUE), ((TextComponent)((TextComponent)Component.text((String)"(").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)String.valueOf(BingoTeam.teams.size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY)));
            BingoTeam team1 = ScoreboardManager.getTeam(0);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._11, (Component)(team1 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team1 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team1.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team1.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
            BingoTeam team2 = ScoreboardManager.getTeam(1);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._10, (Component)(team2 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team2 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team2.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team2.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
            BingoTeam team3 = ScoreboardManager.getTeam(2);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._9, (Component)(team3 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team3 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team3.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team3.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
            BingoTeam team4 = ScoreboardManager.getTeam(3);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._8, (Component)(team4 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team4 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team4.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team4.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
            BingoTeam team5 = ScoreboardManager.getTeam(4);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._7, (Component)(team5 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team5 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team5.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team5.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
            BingoTeam team6 = ScoreboardManager.getTeam(5);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._6, (Component)(team6 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team6 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team6.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team6.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
            BingoTeam team7 = ScoreboardManager.getTeam(6);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._5, (Component)(team7 == null ? Component.empty() : Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)), (Component)(team7 == null ? Component.empty() : ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)team7.getName().color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)" (").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size() - team7.getMissingBingoItems().size())).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)"/").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)String.valueOf(BingoObject.getSelectedObjects().size())).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)")").color((TextColor)NamedTextColor.GRAY))));
        }
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._4, (Component)Component.empty(), (Component)Component.empty());
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._3, ((TranslatableComponent)Component.translatable((String)"game.team.your", (String)"Your Team").append((Component)Component.text((String)": "))).color((TextColor)NamedTextColor.GRAY), BingoTeam.getTeam(player.getUniqueId()).map(bingoTeam -> bingoTeam.getName()).orElse(Component.translatable((String)"game.Spectator", (String)"Spectator").color((TextColor)NamedTextColor.GRAY)));
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._2, (Component)Component.empty(), (Component)Component.empty());
        player.getScoreboard().getEntryTeam(NMSScoreboardBuilder.ScoreboardEntry._1.entry).prefix(ScoreboardManager.getAuthor());
    }

    public static void updateTime(Player player) {
        String time = ScoreboardManager.calcTime();
        NMSScoreboardBuilder.updateTitle(player.getScoreboard(), Main.bingoPrefixComponent.append((Component)(time == null ? Component.empty() : ((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.DARK_GRAY)).append(Component.text((String)time).color((TextColor)NamedTextColor.GRAY)))));
    }

    private static String calcTime() {
        long time;
        long l = time = (Integer)BingoSetting.getSetting(TimeSetting.class).getValue() == 0 ? System.currentTimeMillis() - GameState.time : GameState.time - System.currentTimeMillis();
        if (time <= 0L) {
            return null;
        }
        return String.format("%02d:%02d", time / 1000L / 60L, time / 1000L % 60L);
    }

    private static BingoTeam getTeam(int place) {
        Comparator<BingoTeam> comparator = Comparator.comparingInt(value -> value.getMissingBingoItems().size());
        LinkedList<BingoTeam> teams = new LinkedList<BingoTeam>(BingoTeam.teams.stream().sorted(comparator.thenComparingInt(BingoTeam::getId)).toList());
        if (place >= teams.size()) {
            return null;
        }
        return (BingoTeam)teams.get(place);
    }

    private static Component getItem(Player player, int i) {
        Optional<BingoTeam> optionalTeam = BingoTeam.getTeam(player.getUniqueId());
        if (optionalTeam.isEmpty()) {
            return Component.empty();
        }
        List<BingoObject> sortedObjects = BingoObject.getSelectedObjects().stream().filter(bingoObject -> ((BingoTeam)optionalTeam.get()).getMissingBingoItems().contains(bingoObject)).toList();
        if (sortedObjects.size() <= i) {
            return Component.empty();
        }
        return sortedObjects.get(i).getName().color((TextColor)(sortedObjects.get(i) instanceof BingoObject.BingoItem.EnchantedBingoItem ? NamedTextColor.AQUA : NamedTextColor.GRAY));
    }

    private static BingoObject getObject(Player player, int i) {
        Optional<BingoTeam> optionalTeam = BingoTeam.getTeam(player.getUniqueId());
        if (optionalTeam.isEmpty()) {
            return null;
        }
        List<BingoObject> sortedObjects = BingoObject.getSelectedObjects().stream().filter(bingoObject -> ((BingoTeam)optionalTeam.get()).getMissingBingoItems().contains(bingoObject)).toList();
        if (sortedObjects.size() <= i) {
            return null;
        }
        return sortedObjects.get(i);
    }

    public static Component getAuthor() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"B").color(TextColor.fromHexString((String)"#00b1b8")))).append(Component.text((String)"i").color(TextColor.fromHexString((String)"#00b7b9")))).append(Component.text((String)"n").color(TextColor.fromHexString((String)"#00bdb8")))).append(Component.text((String)"g").color(TextColor.fromHexString((String)"#00c3b6")))).append(Component.text((String)"o").color(TextColor.fromHexString((String)"#00c8b2")))).append((Component)Component.text((String)" "))).append(Component.text((String)"b").color(TextColor.fromHexString((String)"#00cdae")))).append(Component.text((String)"y").color(TextColor.fromHexString((String)"#00d2a8")))).append((Component)Component.text((String)" "))).append(Component.text((String)"E").color(TextColor.fromHexString((String)"#00d7a2")))).append(Component.text((String)"i").color(TextColor.fromHexString((String)"#00dd9a")))).append(Component.text((String)"s").color(TextColor.fromHexString((String)"#00e390")))).append(Component.text((String)"i").color(TextColor.fromHexString((String)"#00e785")))).append(Component.text((String)"0").color(TextColor.fromHexString((String)"#00ec79")))).append(Component.text((String)"5").color(TextColor.fromHexString((String)"#00f06c")))).asComponent();
    }

    private static Component getBingoObjectSymbol(Player player, int i) {
        if (ResourcepackListener.resourcepacks.contains(player.getUniqueId())) {
            return ScoreboardManager.getObject(player, i).getScoreboardIcon().append((Component)Component.text((String)" "));
        }
        return ((TextComponent)Component.text((String)"- ").color((TextColor)NamedTextColor.DARK_GRAY)).append((Component)Component.text((String)" "));
    }
}

