/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils;

import de.eisi05.bingo.utils.eisutils.builder.StringBuilder;
import java.io.Serializable;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public enum BingoDifficulty implements Serializable
{
    EASY(NamedTextColor.GREEN),
    NORMAL(NamedTextColor.YELLOW),
    HARD(NamedTextColor.RED),
    DISABLED(NamedTextColor.DARK_RED);

    private final NamedTextColor color;

    private BingoDifficulty(NamedTextColor color) {
        this.color = color;
    }

    public static BingoDifficulty[] getAll() {
        return Arrays.stream(BingoDifficulty.values()).filter(bingoDifficulty -> bingoDifficulty != DISABLED).toList().toArray(new BingoDifficulty[0]);
    }

    public NamedTextColor getColor() {
        return this.color;
    }

    public Component getName() {
        return ((TranslatableComponent)Component.translatable((String)("difficulty." + this.name().toLowerCase()), (String)new StringBuilder(this.name()).toNormalCase().build()).color((TextColor)this.color)).style(builder -> builder.decoration(TextDecoration.ITALIC, false));
    }

    public BingoDifficulty next(boolean includeDisabled) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NORMAL;
            case 1 -> HARD;
            case 2 -> {
                if (includeDisabled) {
                    yield DISABLED;
                }
                yield EASY;
            }
            case 3 -> includeDisabled ? EASY : DISABLED;
        };
    }

    public BingoDifficulty prev(boolean includeDisabled) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (includeDisabled) {
                    yield DISABLED;
                }
                yield HARD;
            }
            case 1 -> EASY;
            case 2 -> NORMAL;
            case 3 -> includeDisabled ? HARD : DISABLED;
        };
    }
}

