/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.SettingsManager;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.Duration;
import java.util.HashMap;
import java.util.Random;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public final class BingoUtils {
    public static final NamedTextColor[] teamColors = new NamedTextColor[]{NamedTextColor.GREEN, NamedTextColor.RED, NamedTextColor.YELLOW, NamedTextColor.AQUA, NamedTextColor.LIGHT_PURPLE, NamedTextColor.GOLD, NamedTextColor.DARK_GREEN, NamedTextColor.DARK_AQUA, NamedTextColor.DARK_PURPLE};
    public static final ItemStack settingItem = new ItemBuilder(Material.NETHER_STAR).setName(Translation.SETTINGS.color((TextColor)NamedTextColor.AQUA)).setInteractHandler(event -> SettingsManager.getSettingsInventory().open((HumanEntity)event.getPlayer(), new InventoryBuilder.Animation(InventoryBuilder.AnimationType.values()[new Random().nextInt(InventoryBuilder.AnimationType.values().length)], 1, Sound.BLOCK_NOTE_BLOCK_HAT))).notDroppable().build();
    public static final ItemStack startItem = new ItemBuilder(Material.LIME_DYE).setName(Component.translatable((String)"options.start.game", (String)"Start Game").color((TextColor)NamedTextColor.GREEN)).setInteractHandler(event -> {
        if (BingoTeam.teams.stream().allMatch(team -> team.getPlayers().isEmpty())) {
            event.getPlayer().playSound((Entity)event.getPlayer(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
            BingoUtils.sendMessage((HumanEntity)event.getPlayer(), Component.translatable((String)"options.start.failed", (String)"Cannot start the game! There are no players on any team!").color((TextColor)NamedTextColor.RED), true);
            return;
        }
        GameState.setGameState(GameState.STARTING);
    }).notDroppable().build();
    private static final HashMap<Material, Character> materialToCharMap = new HashMap();
    private static final HashMap<EntityType, Character> entityTypeToCharMap = new HashMap();

    public static ItemStack teamSelectItem() {
        return new ItemBuilder(Material.RED_BED).setName(Component.translatable((String)"team.select", (String)"Select Team").color((TextColor)NamedTextColor.RED)).setInteractHandler(event -> BingoTeam.getSelectionInventory(event.getPlayer()).open((HumanEntity)event.getPlayer())).notDroppable().build();
    }

    public static void sendMessage(HumanEntity player, Component component, boolean prefix) {
        if (prefix) {
            component = Prefix.SERVER.append(component);
        }
        player.sendMessage(component);
    }

    public static void sendTitle(HumanEntity player, Component title, Component subtitle, long fadeIn, long stay, long fadeOut) {
        player.showTitle(Title.title((Component)(title == null ? Component.empty() : title), (Component)(subtitle == null ? Component.empty() : subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeIn * 50L), (Duration)Duration.ofMillis(stay * 50L), (Duration)Duration.ofMillis(fadeOut * 50L))));
    }

    public static Component getItemIcon(Material material, Component defaultChar) {
        return materialToCharMap.getOrDefault(material, null) == null ? defaultChar : Component.text((String)String.valueOf(materialToCharMap.get(material)));
    }

    public static Component getEntityIcon(EntityType type, Component defaultChar) {
        return entityTypeToCharMap.getOrDefault(type, null) == null ? defaultChar : Component.text((String)String.valueOf(entityTypeToCharMap.get(type)));
    }

    static {
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(BingoUtils.class.getClassLoader().getResourceAsStream("CharMapping.yml")));
        for (String key : configuration.getConfigurationSection("materials").getKeys(false)) {
            materialToCharMap.put(Material.valueOf((String)key.toUpperCase()), Character.valueOf((char)Integer.parseInt(configuration.getString("materials." + key).replace("\\u", ""), 16)));
        }
        for (String key : configuration.getConfigurationSection("entity").getKeys(false)) {
            entityTypeToCharMap.put(EntityType.valueOf((String)key.toUpperCase()), Character.valueOf((char)Integer.parseInt(configuration.getString("entity." + key).replace("\\u", ""), 16)));
        }
    }
}

