/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class TripleMap<A, B, C> {
    private final List<Triple<A, B, C>> list = new ArrayList<Triple<A, B, C>>();

    public void put(A a, B b, C c) {
        this.list.add(Triple.of(a, b, c));
    }

    public Pair<B, C> get(A a) {
        for (Triple<A, B, C> triple : this.list) {
            if (!triple.getLeft().equals(a)) continue;
            return Pair.of((Object)triple.getMiddle(), (Object)triple.getRight());
        }
        return null;
    }

    public B getFirstOrDefault(A a, B defaultB) {
        for (Triple<A, B, C> triple : this.list) {
            if (!triple.getLeft().equals(a)) continue;
            return (B)triple.getMiddle();
        }
        return defaultB;
    }

    public C getSecondOrDefault(A a, C defaultC) {
        for (Triple<A, B, C> triple : this.list) {
            if (!triple.getLeft().equals(a)) continue;
            return (C)triple.getRight();
        }
        return defaultC;
    }

    public boolean containsKey(A a) {
        return this.get(a) != null;
    }
}

