/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.builder;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.eisi05.bingo.Main;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import de.eisi05.bingo.utils.eisutils.config.ItemConfiguration;
import de.eisi05.bingo.utils.eisutils.inventory.ScrollInventoryEvent;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder
implements Listener {
    private final HashMap<Enchantment, Integer> enchantments;
    private final UUID id;
    protected ItemStack item;
    protected ItemMeta meta;
    private Consumer<InventoryClickEvent> function;
    private ScrollInventoryEvent scrollInventoryEvent;
    private ScrollInventory scrollInventory;
    private Consumer<PlayerInteractEvent> interactEvent;
    private boolean notDroppable = false;

    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemBuilder(Material material, int amount) {
        this(new ItemStack(material, amount));
    }

    public ItemBuilder(ItemStack item) {
        this.item = item;
        this.id = UUID.randomUUID();
        if (item.getType() != Material.AIR) {
            new ItemConfiguration<String>(item).setData("id", this.id.toString());
        }
        this.meta = item.getItemMeta();
        this.enchantments = new HashMap();
        Bukkit.getPluginManager().registerEvents((Listener)this, Main.plugin);
    }

    public static ItemStack PlaceHolder() {
        return new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName((Component)Component.text((String)" ")).hideToolTip().build();
    }

    public static List<Component> getLore(ItemStack item) {
        return item.lore();
    }

    public static ItemStack setLore(ItemStack item, List<Component> components) {
        item.lore(components);
        return item;
    }

    public ItemBuilder setName(Component name) {
        this.meta.displayName(name);
        this.meta.customName(name);
        this.meta.itemName(name);
        return this;
    }

    public ItemBuilder setLore(Component ... components) {
        this.meta.lore(List.of(components));
        return this;
    }

    public ItemBuilder addLore(Component ... lore) {
        if (this.meta.hasLore()) {
            List list = this.meta.lore();
            list.addAll(Arrays.stream(lore).filter(Objects::nonNull).toList());
            this.setLore(list.toArray(new Component[0]));
        } else {
            this.setLore(lore);
        }
        return this;
    }

    public ItemBuilder notDroppable() {
        this.notDroppable = true;
        return this;
    }

    public ItemBuilder flags() {
        this.meta.addItemFlags(Arrays.stream(ItemFlag.values()).filter(itemFlag -> {
            switch (itemFlag) {
                default: 
            }
            return true;
        }).toList().toArray(new ItemFlag[0]));
        return this;
    }

    public ItemBuilder hideToolTip() {
        this.meta.setHideTooltip(true);
        return this;
    }

    public ItemBuilder clearAttributes() {
        this.meta.setAttributeModifiers((Multimap)Multimaps.forMap(new HashMap()));
        this.item.setData(DataComponentTypes.ATTRIBUTE_MODIFIERS, (Object)((ItemAttributeModifiers)ItemAttributeModifiers.itemAttributes().build()));
        return this;
    }

    public ItemBuilder setAttributes(HashMap<Attribute, AttributeModifier> map) {
        this.meta.setAttributeModifiers((Multimap)Multimaps.forMap(map));
        return this;
    }

    public ItemBuilder setRarity(ItemRarity rarity) {
        this.meta.setRarity(rarity);
        return this;
    }

    public ItemBuilder setEnchantmentGlint(boolean enchantmentGlint) {
        this.meta.setEnchantmentGlintOverride(Boolean.valueOf(enchantmentGlint));
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        for (Enchantment enchantment : this.enchantments.keySet()) {
            this.item.addUnsafeEnchantment(enchantment, this.enchantments.get(enchantment).intValue());
        }
        return this.item;
    }

    public ItemBuilder setClickHandler(Consumer<InventoryClickEvent> function) {
        this.function = function;
        return this;
    }

    public ItemBuilder setScrollClickHandler(ScrollInventoryEvent scrollInventoryEvent, ScrollInventory scrollInventory) {
        this.scrollInventoryEvent = scrollInventoryEvent;
        this.scrollInventory = scrollInventory;
        return this;
    }

    public ItemBuilder setInteractHandler(Consumer<PlayerInteractEvent> interactEvent) {
        this.interactEvent = interactEvent;
        return this;
    }

    public ItemBuilder removeEvents() {
        this.function = null;
        this.interactEvent = null;
        return this;
    }

    public Consumer<InventoryClickEvent> getFunction() {
        return this.function;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (event.getSlot() < 0) {
            return;
        }
        if (event.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (!event.getCurrentItem().hasItemMeta()) {
            return;
        }
        if (!new ItemConfiguration(event.getCurrentItem()).hasData("id")) {
            return;
        }
        if (!UUID.fromString((String)new ItemConfiguration(event.getCurrentItem()).getData("id")).equals(this.id)) {
            return;
        }
        if (this.function != null) {
            event.setCancelled(true);
            this.function.accept(event);
        } else if (this.scrollInventoryEvent != null) {
            event.setCancelled(true);
            this.scrollInventoryEvent.call(event, this.scrollInventory);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (event.getItemDrop() == null) {
            return;
        }
        if (event.getItemDrop().getItemStack() == null) {
            return;
        }
        if (event.getItemDrop().getItemStack().getType().isAir()) {
            return;
        }
        if (!event.getItemDrop().getItemStack().hasItemMeta()) {
            return;
        }
        if (!new ItemConfiguration(event.getItemDrop().getItemStack()).hasData("id")) {
            return;
        }
        if (!UUID.fromString((String)new ItemConfiguration(event.getItemDrop().getItemStack()).getData("id")).equals(this.id)) {
            return;
        }
        if (!this.notDroppable) {
            return;
        }
        ItemStack i1 = event.getItemDrop().getItemStack().clone();
        ItemStack i2 = this.item.clone();
        RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).forEach(enchantment -> {
            i1.removeEnchantment(enchantment);
            i2.removeEnchantment(enchantment);
        });
        if (this.item.getType() == Material.PLAYER_HEAD) {
            if (this.isEquals(event.getItemDrop().getItemStack())) {
                event.setCancelled(true);
            }
        } else if (i1.isSimilar(i2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEvent event) {
        if (event.getItem() == null) {
            return;
        }
        if (event.getItem().getType().isAir()) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!event.getItem().hasItemMeta()) {
            return;
        }
        if (!new ItemConfiguration(event.getItem()).hasData("id")) {
            return;
        }
        if (!UUID.fromString((String)new ItemConfiguration(event.getItem()).getData("id")).equals(this.id)) {
            return;
        }
        ItemStack i1 = event.getItem().clone();
        ItemStack i2 = this.item.clone();
        RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).forEach(enchantment -> {
            i1.removeEnchantment(enchantment);
            i2.removeEnchantment(enchantment);
        });
        if (this.item.getType() == Material.PLAYER_HEAD) {
            if (this.isEquals(event.getItem()) && this.interactEvent != null) {
                event.setCancelled(true);
                this.interactEvent.accept(event);
            }
        } else if (i1.isSimilar(i2) && this.interactEvent != null) {
            event.setCancelled(true);
            this.interactEvent.accept(event);
        }
    }

    private boolean isEquals(ItemStack item) {
        if (item.getType() != this.item.getType()) {
            return false;
        }
        if (item.getAmount() != this.item.getAmount()) {
            return false;
        }
        return item.getItemMeta().displayName().equals((Object)this.item.getItemMeta().displayName());
    }
}

