/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.builder;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class NMSScoreboardBuilder {
    private final Scoreboard scoreboard;

    public NMSScoreboardBuilder(Component displayName, DisplaySlot displaySlot, Criteria criteria) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("abc", criteria, displayName, RenderType.INTEGER);
        if (displaySlot != null) {
            objective.setDisplaySlot(displaySlot);
        }
        this.scoreboard = scoreboard;
    }

    public NMSScoreboardBuilder(Player player) {
        this.scoreboard = player.getScoreboard();
    }

    public static void updateTitle(Scoreboard scoreboard, Component title) {
        scoreboard.getObjective("abc").displayName(title);
    }

    public NMSScoreboardBuilder setDisplaySlot(DisplaySlot displaySlot) {
        this.scoreboard.getObjective("abc").setDisplaySlot(displaySlot);
        return this;
    }

    public NMSScoreboardBuilder addScore(ScoreboardEntry entry, Component prefix, Component suffix) {
        if (this.scoreboard.getEntryTeam(entry.entry) == null) {
            Team t = this.scoreboard.registerNewTeam(entry.name());
            t.prefix(prefix);
            t.suffix(suffix);
            t.addEntry(entry.entry);
        }
        this.scoreboard.getObjective("abc").getScore(entry.entry).setScore(entry.ordinal());
        return this;
    }

    public void updateScore(ScoreboardEntry entry, Component prefix, Component suffix) {
        try {
            Team team = this.scoreboard.getEntryTeam(entry.entry);
            team.prefix(prefix);
            team.suffix(suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove() {
        for (Objective objective : this.scoreboard.getObjectives()) {
            objective.unregister();
        }
    }

    public void updateScoreAll(ScoreboardEntry entry, Component prefix, Component suffix) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            new NMSScoreboardBuilder(player).updateScore(entry, prefix, suffix);
        }
    }

    public NMSScoreboardBuilder addTeam(String name, ScoreboardEntry entry, Component prefix, Component suffix, NamedTextColor color) {
        return this.addTeam(name, entry.entry, prefix, suffix, color);
    }

    public NMSScoreboardBuilder addTeam(String name, String entry, Component prefix, Component suffix, NamedTextColor color) {
        Team t = this.scoreboard.registerNewTeam(name);
        t.prefix(prefix);
        t.suffix(suffix);
        t.addEntry(entry);
        t.color(color);
        t.setCanSeeFriendlyInvisibles(true);
        return this;
    }

    public NMSScoreboardBuilder addPlayerToTeam(OfflinePlayer player, String name) {
        if (!this.scoreboard.getTeam(name).hasPlayer(player)) {
            this.scoreboard.getTeam(name).addPlayer(player);
        }
        return this;
    }

    public NMSScoreboardBuilder removePlayerFromTeam(OfflinePlayer player, String name) {
        this.scoreboard.getTeam(name).removePlayer(player);
        return this;
    }

    public NMSScoreboardBuilder addPlayerToTeamByEntry(OfflinePlayer player, String entry) {
        if (!this.scoreboard.getEntryTeam(entry).hasPlayer(player)) {
            this.scoreboard.getEntryTeam(entry).addPlayer(player);
        }
        return this;
    }

    public Scoreboard build() {
        return this.scoreboard;
    }

    public static enum ScoreboardEntry {
        _1("\u00a70"),
        _2("\u00a71"),
        _3("\u00a72"),
        _4("\u00a73"),
        _5("\u00a74"),
        _6("\u00a75"),
        _7("\u00a76"),
        _8("\u00a77"),
        _9("\u00a78"),
        _10("\u00a79"),
        _11("\u00a7a"),
        _12("\u00a7b"),
        _13("\u00a7c"),
        _14("\u00a7d"),
        _15("\u00a7e");

        public final String entry;

        private ScoreboardEntry(String entry) {
            this.entry = entry;
        }
    }
}

