/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.inventory;

import de.eisi05.bingo.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;

public class InventorySaver
implements Listener {
    public static final HashMap<HumanEntity, List<InventoryView>> map = new HashMap();

    public InventorySaver(Plugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    public static InventoryView getInventoryView(HumanEntity entity, int before) {
        try {
            List views = map.getOrDefault(entity, new ArrayList());
            return (InventoryView)views.get(views.size() - 1 - before);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isInventoryView(HumanEntity entity, int before) {
        return InventorySaver.getInventoryView(entity, before) != null;
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (this.contains(event.getPlayer(), event.getView().title())) {
            List views = map.getOrDefault(event.getPlayer(), new ArrayList());
            int index = views.indexOf(this.getView(event.getPlayer(), event.getView().title()));
            views = views.subList(index + 1, views.size());
            map.put(event.getPlayer(), views);
        } else {
            this.add(event.getPlayer(), event.getView());
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(Main.plugin, () -> {
            if (PlainTextComponentSerializer.plainText().serialize(event.getPlayer().getOpenInventory().title()).equalsIgnoreCase("Crafting")) {
                map.remove(event.getPlayer());
            }
        }, 0L);
    }

    private InventoryView getView(HumanEntity entity, Component title) {
        List views = map.getOrDefault(entity, new ArrayList());
        for (InventoryView view : views) {
            if (!PlainTextComponentSerializer.plainText().serialize(view.title()).equalsIgnoreCase(PlainTextComponentSerializer.plainText().serialize(title))) continue;
            return view;
        }
        return null;
    }

    private boolean contains(HumanEntity entity, Component title) {
        return this.getView(entity, title) != null;
    }

    private void add(HumanEntity entity, InventoryView view) {
        List views = map.getOrDefault(entity, new ArrayList());
        views.add(view);
        map.put(entity, views);
    }
}

