/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.lists;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.MinecraftExperimental;
import org.bukkit.Tag;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public final class ItemList {
    public static List<Material> materials = Arrays.stream(Material.values()).filter(material -> material.isItem() & !material.isAir()).filter(material -> {
        try {
            return !Material.class.getDeclaredField(material.name()).isAnnotationPresent(MinecraftExperimental.class);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }).toList();
    public static List<ItemStack> itemStacks = materials.stream().map(ItemStack::new).toList();
    public static List<Material> notObtainableInSurvival = new ArrayList<Material>(){
        {
            this.add(Material.BEDROCK);
            this.add(Material.BUDDING_AMETHYST);
            this.add(Material.CHORUS_PLANT);
            this.add(Material.SPAWNER);
            this.add(Material.FARMLAND);
            this.add(Material.INFESTED_STONE);
            this.add(Material.INFESTED_COBBLESTONE);
            this.add(Material.INFESTED_STONE_BRICKS);
            this.add(Material.INFESTED_MOSSY_STONE_BRICKS);
            this.add(Material.INFESTED_CRACKED_STONE_BRICKS);
            this.add(Material.INFESTED_CHISELED_STONE_BRICKS);
            this.add(Material.INFESTED_DEEPSLATE);
            this.add(Material.REINFORCED_DEEPSLATE);
            this.add(Material.END_PORTAL_FRAME);
            this.add(Material.COMMAND_BLOCK);
            this.add(Material.BARRIER);
            this.add(Material.LIGHT);
            this.add(Material.REPEATING_COMMAND_BLOCK);
            this.add(Material.CHAIN_COMMAND_BLOCK);
            this.add(Material.STRUCTURE_VOID);
            this.add(Material.STRUCTURE_BLOCK);
            this.add(Material.JIGSAW);
            this.add(Material.PLAYER_HEAD);
            this.add(Material.COMMAND_BLOCK_MINECART);
            this.add(Material.SPLASH_POTION);
            this.add(Material.TIPPED_ARROW);
            this.add(Material.LINGERING_POTION);
            this.add(Material.POTION);
            this.add(Material.KNOWLEDGE_BOOK);
            this.add(Material.DEBUG_STICK);
            this.add(Material.VAULT);
            this.add(Material.TRIAL_SPAWNER);
            this.add(Material.DIRT_PATH);
            this.add(Material.FROGSPAWN);
            this.add(Material.SUSPICIOUS_SAND);
            this.add(Material.SUSPICIOUS_GRAVEL);
            this.add(Material.PETRIFIED_OAK_SLAB);
            this.add(Material.TEST_BLOCK);
            this.add(Material.TEST_INSTANCE_BLOCK);
            this.addAll(materials.stream().filter(material -> material.name().contains("SPAWN_EGG")).toList());
            this.addAll(materials.stream().filter(material -> material.name().contains("MUSIC_DISC")).toList());
            this.addAll(materials.stream().filter(material -> material.name().contains("BANNER_PATTERN")).toList());
            this.addAll(Tag.ITEMS_TRIM_MATERIALS.getValues());
        }
    };
    public static List<Material> netherItems = new ArrayList<Material>(){
        {
            this.add(Material.CRIMSON_NYLIUM);
            this.add(Material.WARPED_NYLIUM);
            this.add(Material.CRIMSON_PLANKS);
            this.add(Material.WARPED_PLANKS);
            this.add(Material.NETHER_GOLD_ORE);
            this.add(Material.NETHER_QUARTZ_ORE);
            this.add(Material.ANCIENT_DEBRIS);
            this.add(Material.NETHERITE_BLOCK);
            this.add(Material.CRIMSON_STEM);
            this.add(Material.WARPED_STEM);
            this.add(Material.STRIPPED_CRIMSON_STEM);
            this.add(Material.STRIPPED_WARPED_STEM);
            this.add(Material.STRIPPED_CRIMSON_HYPHAE);
            this.add(Material.STRIPPED_WARPED_HYPHAE);
            this.add(Material.CRIMSON_HYPHAE);
            this.add(Material.WARPED_HYPHAE);
            this.add(Material.CRIMSON_FUNGUS);
            this.add(Material.WARPED_FUNGUS);
            this.add(Material.CRIMSON_ROOTS);
            this.add(Material.WARPED_ROOTS);
            this.add(Material.NETHER_SPROUTS);
            this.add(Material.WEEPING_VINES);
            this.add(Material.TWISTING_VINES);
            this.add(Material.CRIMSON_SLAB);
            this.add(Material.WARPED_SLAB);
            this.add(Material.CRIMSON_FENCE);
            this.add(Material.WARPED_FENCE);
            this.add(Material.SOUL_SAND);
            this.add(Material.SOUL_SOIL);
            this.add(Material.BASALT);
            this.add(Material.POLISHED_BASALT);
            this.add(Material.SMOOTH_BASALT);
            this.add(Material.ENDER_CHEST);
            this.add(Material.CRIMSON_STAIRS);
            this.add(Material.WARPED_STAIRS);
            this.add(Material.BEACON);
            this.add(Material.BLACKSTONE_WALL);
            this.add(Material.POLISHED_BLACKSTONE_WALL);
            this.add(Material.POLISHED_BLACKSTONE_BRICK_WALL);
            this.add(Material.CHISELED_QUARTZ_BLOCK);
            this.add(Material.QUARTZ_BLOCK);
            this.add(Material.QUARTZ_BRICKS);
            this.add(Material.QUARTZ_PILLAR);
            this.add(Material.QUARTZ_STAIRS);
            this.add(Material.NETHER_WART_BLOCK);
            this.add(Material.WARPED_WART_BLOCK);
            this.add(Material.COMPARATOR);
            this.add(Material.REDSTONE_LAMP);
            this.add(Material.DAYLIGHT_DETECTOR);
            this.add(Material.POLISHED_BLACKSTONE_BUTTON);
            this.add(Material.CRIMSON_BUTTON);
            this.add(Material.WARPED_BUTTON);
            this.add(Material.POLISHED_BLACKSTONE_PRESSURE_PLATE);
            this.add(Material.CRIMSON_PRESSURE_PLATE);
            this.add(Material.WARPED_PRESSURE_PLATE);
            this.add(Material.CRIMSON_DOOR);
            this.add(Material.WARPED_DOOR);
            this.add(Material.CRIMSON_TRAPDOOR);
            this.add(Material.WARPED_TRAPDOOR);
            this.add(Material.CRIMSON_FENCE_GATE);
            this.add(Material.WARPED_FENCE_GATE);
            this.add(Material.WARPED_FUNGUS_ON_A_STICK);
            this.add(Material.QUARTZ);
            this.add(Material.NETHERITE_INGOT);
            this.add(Material.NETHERITE_SCRAP);
            this.add(Material.NETHERITE_SWORD);
            this.add(Material.NETHERITE_SHOVEL);
            this.add(Material.NETHERITE_PICKAXE);
            this.add(Material.NETHERITE_AXE);
            this.add(Material.NETHERITE_HOE);
            this.add(Material.NETHERITE_HELMET);
            this.add(Material.NETHERITE_CHESTPLATE);
            this.add(Material.NETHERITE_LEGGINGS);
            this.add(Material.NETHERITE_BOOTS);
            this.add(Material.NETHERITE_BLOCK);
            this.add(Material.CRIMSON_SIGN);
            this.add(Material.WARPED_SIGN);
            this.add(Material.CRIMSON_HANGING_SIGN);
            this.add(Material.WARPED_HANGING_SIGN);
            this.add(Material.SOUL_TORCH);
            this.add(Material.GLOWSTONE);
            this.add(Material.BLAZE_ROD);
            this.add(Material.GHAST_TEAR);
            this.add(Material.NETHER_WART);
            this.add(Material.BLAZE_POWDER);
            this.add(Material.MAGMA_CREAM);
            this.add(Material.BREWING_STAND);
            this.add(Material.ENDER_EYE);
            this.add(Material.PIGLIN_HEAD);
            this.add(Material.NETHER_STAR);
            this.add(Material.END_CRYSTAL);
            this.add(Material.SPECTRAL_ARROW);
            this.add(Material.SOUL_LANTERN);
            this.add(Material.SOUL_CAMPFIRE);
            this.add(Material.SHROOMLIGHT);
            this.add(Material.LODESTONE);
            this.add(Material.BLACKSTONE);
            this.add(Material.BLACKSTONE_SLAB);
            this.add(Material.BLACKSTONE_STAIRS);
            this.add(Material.GILDED_BLACKSTONE);
            this.add(Material.POLISHED_BLACKSTONE);
            this.add(Material.POLISHED_BLACKSTONE_SLAB);
            this.add(Material.POLISHED_BLACKSTONE_STAIRS);
            this.add(Material.CHISELED_POLISHED_BLACKSTONE);
            this.add(Material.POLISHED_BLACKSTONE_BRICKS);
            this.add(Material.POLISHED_BLACKSTONE_BRICK_SLAB);
            this.add(Material.POLISHED_BLACKSTONE_BRICK_STAIRS);
            this.add(Material.CRACKED_POLISHED_BLACKSTONE_BRICKS);
            this.add(Material.RESPAWN_ANCHOR);
            this.add(Material.NETHERITE_UPGRADE_SMITHING_TEMPLATE);
            this.add(Material.OCHRE_FROGLIGHT);
            this.add(Material.VERDANT_FROGLIGHT);
            this.add(Material.PEARLESCENT_FROGLIGHT);
            this.add(Material.DRIED_GHAST);
            this.add(Material.MUSIC_DISC_TEARS);
        }
    };
    public static List<Material> endItems = new ArrayList<Material>(){
        {
            this.add(Material.PURPUR_SLAB);
            this.add(Material.END_ROD);
            this.add(Material.CHORUS_FLOWER);
            this.add(Material.PURPUR_BLOCK);
            this.add(Material.PURPUR_PILLAR);
            this.add(Material.PURPUR_STAIRS);
            this.add(Material.END_STONE);
            this.add(Material.END_STONE_BRICKS);
            this.add(Material.DRAGON_EGG);
            this.add(Material.END_STONE_BRICK_WALL);
            this.add(Material.END_STONE_BRICK_STAIRS);
            this.add(Material.END_STONE_BRICK_SLAB);
            this.add(Material.ELYTRA);
            this.add(Material.DRAGON_HEAD);
            this.add(Material.CHORUS_FRUIT);
            this.add(Material.POPPED_CHORUS_FRUIT);
            this.add(Material.DRAGON_BREATH);
            this.add(Material.SHULKER_SHELL);
            this.addAll(Tag.SHULKER_BOXES.getValues());
        }
    };

    public static List<Enchantment> getAvailableEnchantments(ItemStack itemStack) {
        return RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).stream().filter(enchantment -> enchantment.canEnchantItem(itemStack)).toList();
    }
}

