/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.AllowEnchantmentsSetting;
import de.eisi05.bingo.bingo.settings.AmountOfObjectsSetting;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.DamageSetting;
import de.eisi05.bingo.bingo.settings.DifficultySetting;
import de.eisi05.bingo.bingo.settings.EndSetting;
import de.eisi05.bingo.bingo.settings.NetherSetting;
import de.eisi05.bingo.bingo.settings.ObjectTypesSetting;
import de.eisi05.bingo.bingo.settings.PVPSetting;
import de.eisi05.bingo.bingo.settings.RandomizerSetting;
import de.eisi05.bingo.manager.RandomizeManager;
import de.eisi05.bingo.utils.BingoData;
import de.eisi05.bingo.utils.BingoDifficulty;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.StringBuilder;
import de.eisi05.bingo.utils.eisutils.inventory.ItemSerialization;
import de.eisi05.bingo.utils.eisutils.lists.AdvancementList;
import de.eisi05.bingo.utils.eisutils.lists.BiomeList;
import de.eisi05.bingo.utils.eisutils.lists.EntityList;
import de.eisi05.bingo.utils.eisutils.lists.ItemList;
import de.eisi05.bingo.utils.eisutils.lists.StructureList;
import de.eisi05.bingo.utils.lang.Translation;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.objects.AtlasSprite;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.resources.MinecraftKey;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R6.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract sealed class BingoObject<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final List<BingoObject<?>> bingoObjects = new ArrayList();
    private static List<BingoObject<?>> selectedObjects;
    protected final T object;
    protected BingoDifficulty bingoDifficulty;

    public BingoObject(T object, BingoDifficulty bingoDifficulty) {
        this.object = object;
        this.bingoDifficulty = bingoDifficulty;
        if (!this.getClass().equals(BingoItem.EnchantedBingoItem.class)) {
            bingoObjects.add(this);
        }
    }

    public static void loadBingoObjects() {
        ItemList.itemStacks.stream().filter(itemStack -> !ItemList.notObtainableInSurvival.contains(itemStack.getType())).filter(itemStack -> BingoObject.getBingoObjects(BingoItem.class).stream().filter(itemStackBingoObject -> itemStackBingoObject != null && itemStackBingoObject.object != null).noneMatch(bingoObject -> bingoObject.compare((ItemStack)BingoObject.cast(itemStack)))).forEach(itemStack -> {
            BingoDifficulty bingoDifficulty;
            if (itemStack.getItemMeta().hasRarity()) {
                switch (itemStack.getItemMeta().getRarity()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case COMMON: {
                        bingoDifficulty = BingoDifficulty.EASY;
                        break;
                    }
                    case UNCOMMON: 
                    case RARE: {
                        bingoDifficulty = BingoDifficulty.NORMAL;
                        break;
                    }
                    case EPIC: {
                        bingoDifficulty = BingoDifficulty.HARD;
                        break;
                    }
                }
            } else {
                bingoDifficulty = BingoDifficulty.EASY;
            }
            new BingoItem((ItemStack)itemStack, bingoDifficulty);
        });
        BiomeList.biomeMap.keySet().stream().filter(Objects::nonNull).filter(biome -> BingoObject.getBingoObjects(BingoBiome.class).stream().noneMatch(bingoObject -> bingoObject.compare((Biome)BingoObject.cast(biome)))).forEach(biome -> new BingoBiome((Biome)biome, BiomeList.netherBiomes.contains(biome) ? BingoDifficulty.NORMAL : (BiomeList.endBiomes.contains(biome) ? BingoDifficulty.HARD : BingoDifficulty.EASY)));
        Bukkit.advancementIterator().forEachRemaining(advancement -> {
            if (advancement.getDisplay() == null) {
                return;
            }
            if (((CraftAdvancement)advancement).getHandle().b().a()) {
                return;
            }
            if (BingoObject.getBingoObjects(BingoAdvancement.class).stream().anyMatch(bingoObject -> bingoObject.compare((Advancement)BingoObject.cast(advancement)))) {
                return;
            }
            new BingoAdvancement((Advancement)advancement, AdvancementList.netherAdvancements.contains(advancement) ? BingoDifficulty.NORMAL : (AdvancementList.endAdvancements.contains(advancement) ? BingoDifficulty.HARD : BingoDifficulty.EASY));
        });
        Registry.STRUCTURE.stream().filter(structure -> BingoObject.getBingoObjects(BingoStructure.class).stream().noneMatch(bingoObject -> bingoObject.compare((Structure)BingoObject.cast(structure)))).forEach(structure -> new BingoStructure((Structure)structure, StructureList.netherStructures.contains(structure) ? BingoDifficulty.NORMAL : (StructureList.endStructures.contains(structure) ? BingoDifficulty.HARD : BingoDifficulty.EASY)));
        Arrays.stream(EntityType.values()).forEach(entityType -> {
            if (entityType.getEntityClass() == null) {
                return;
            }
            if (entityType.getEntityClass().isAnnotationPresent(MinecraftExperimental.class)) {
                return;
            }
            if (BingoObject.getBingoObjects(BingoEntity.class).stream().anyMatch(bingoObject -> bingoObject.compare((EntityType)BingoObject.cast(entityType)))) {
                return;
            }
            if (entityType == EntityType.ILLUSIONER || entityType == EntityType.GIANT || entityType == EntityType.ZOMBIE_HORSE) {
                return;
            }
            if (Mob.class.isAssignableFrom(entityType.getEntityClass())) {
                new BingoEntity((EntityType)entityType, EntityList.netherEntities.contains(entityType) ? BingoDifficulty.NORMAL : (EntityList.endEntities.contains(entityType) ? BingoDifficulty.HARD : BingoDifficulty.EASY));
            }
        });
    }

    public static List<BingoObject<?>> getAvailableObjects() {
        return bingoObjects.stream().filter(bingoObject -> {
            if (!((Boolean)BingoSetting.getSetting(NetherSetting.class).getValue()).booleanValue() && (bingoObject.isNetherObject() || bingoObject.isEndObject())) {
                return false;
            }
            if (!((Boolean)BingoSetting.getSetting(EndSetting.class).getValue()).booleanValue() && bingoObject.isEndObject()) {
                return false;
            }
            if (((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).getOrDefault(bingoObject.getClass(), 0) == 0) {
                return false;
            }
            return bingoObject.getDifficulty().ordinal() <= ((BingoDifficulty)BingoSetting.getSetting(DifficultySetting.class).getValue()).ordinal();
        }).toList();
    }

    public static List<BingoObject<?>> getSelectedObjects() {
        return selectedObjects;
    }

    public static void calculateNewSelectedObjects() {
        if (((Boolean)BingoSetting.getSetting(RandomizerSetting.class).getValue()).booleanValue()) {
            BingoSetting.getSetting(DifficultySetting.class).setValue(BingoDifficulty.HARD);
            BingoSetting.getSetting(EndSetting.class).setValue(true);
            BingoSetting.getSetting(NetherSetting.class).setValue(true);
            RandomizeManager.createMapping();
        }
        List<BingoObject<?>> availableObjects = BingoObject.getAvailableObjects();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        HashMap<Class, ArrayDeque> grouped = new HashMap<Class, ArrayDeque>();
        for (BingoObject<?> obj : availableObjects) {
            grouped.computeIfAbsent(obj.getClass(), k -> new ArrayDeque()).add(obj);
        }
        for (ArrayDeque q : grouped.values()) {
            ArrayList tmp = new ArrayList(q);
            Collections.shuffle(tmp, rnd);
            q.clear();
            q.addAll(tmp);
        }
        int amount = (Integer)BingoSetting.getSetting(AmountOfObjectsSetting.class).getValue();
        HashMap weights = new HashMap((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue());
        int totalWeight = 0;
        Iterator iterator = weights.values().iterator();
        while (iterator.hasNext()) {
            int w = (Integer)iterator.next();
            totalWeight += w;
        }
        if (totalWeight == 0) {
            totalWeight = 1;
        }
        ArrayList<BingoObject<Object>> selected = new ArrayList(amount);
        for (Map.Entry entry : grouped.entrySet()) {
            int weight = weights.getOrDefault(entry.getKey(), 1);
            int pickCount = weight * amount / totalWeight;
            for (int i = 0; i < pickCount && !((ArrayDeque)entry.getValue()).isEmpty(); ++i) {
                BingoObject obj = (BingoObject)((ArrayDeque)entry.getValue()).poll();
                if (obj instanceof BingoItem) {
                    List<Enchantment> enchantments;
                    BingoItem item = (BingoItem)obj;
                    if (((Boolean)BingoSetting.getSetting(AllowEnchantmentsSetting.class).getValue()).booleanValue() && !(enchantments = ItemList.getAvailableEnchantments(((ItemStack)item.getObject()).clone())).isEmpty() && rnd.nextBoolean()) {
                        Enchantment chosen = enchantments.get(rnd.nextInt(enchantments.size()));
                        ItemStack enchanted = ((ItemStack)item.getObject()).clone();
                        enchanted.addUnsafeEnchantment(chosen, 1);
                        selected.add(new BingoItem.EnchantedBingoItem(enchanted, obj.getDifficulty()));
                        continue;
                    }
                }
                selected.add(obj);
            }
        }
        if (selected.size() < amount) {
            ArrayList<ArrayDeque> nonEmpty = new ArrayList<ArrayDeque>();
            for (ArrayDeque q : grouped.values()) {
                if (q.isEmpty()) continue;
                nonEmpty.add(q);
            }
            while (selected.size() < amount && !nonEmpty.isEmpty()) {
                ArrayDeque arrayDeque = (ArrayDeque)nonEmpty.get(rnd.nextInt(nonEmpty.size()));
                BingoObject obj = (BingoObject)arrayDeque.poll();
                if (obj != null) {
                    selected.add(obj);
                }
                if (!arrayDeque.isEmpty()) continue;
                nonEmpty.remove(arrayDeque);
            }
        }
        if (selected.size() > amount) {
            selected = new ArrayList(selected.subList(0, amount));
        }
        Collections.shuffle(selected, rnd);
        selectedObjects = selected;
        for (BingoObject<?> bingoObject : selectedObjects) {
            BingoAdvancement adv;
            if (bingoObject.getObject() == EntityType.PLAYER) {
                BingoSetting.getSetting(PVPSetting.class).setValue(true);
            }
            if (!(bingoObject instanceof BingoAdvancement) || !"adventure/totem_of_undying".equals(((Advancement)(adv = (BingoAdvancement)bingoObject).getObject()).getKey().getKey())) continue;
            BingoSetting.getSetting(DamageSetting.class).setValue(true);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BingoObject)) {
            return false;
        }
        BingoObject bingoObject = (BingoObject)obj;
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        return this.isSimilarObject(bingoObject.object);
    }

    public static IChatMutableComponent getName(@NotNull Player player, @NotNull Class<? extends BingoObject<?>> clazz) {
        return Translation.translate(player, clazz.getAnnotation(BingoData.class).key(), new Object[0]);
    }

    public static Material getIcon(Class<? extends BingoObject<?>> clazz) {
        return clazz.getAnnotation(BingoData.class).icon();
    }

    public static Class<? extends BingoObject<?>>[] getClasses() {
        return Arrays.stream(BingoObject.class.getPermittedSubclasses()).map(aClass -> aClass).toList().toArray(new Class[0]);
    }

    public static <T> List<BingoObject<T>> getBingoObjects(Class<? extends BingoObject<T>> c) {
        return bingoObjects.stream().filter(bingoObject -> bingoObject.getClass().isAssignableFrom(c)).map(c::cast).map(tBingoObject -> tBingoObject).filter(Objects::nonNull).toList();
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    public abstract boolean isSimilarObject(T var1);

    public abstract IChatMutableComponent getFoundVerb(@NotNull Player var1);

    protected abstract ItemStack asDisplay();

    public abstract IChatMutableComponent getName();

    public abstract IChatMutableComponent getScoreboardIcon();

    public abstract boolean isNetherObject();

    public abstract boolean isEndObject();

    abstract boolean compare(T var1);

    public ItemStack asDisplayIcon() {
        ItemRarity rarity = this.isNetherObject() ? ItemRarity.EPIC : (this.isEndObject() ? ItemRarity.UNCOMMON : ItemRarity.COMMON);
        return new ItemBuilder(this.asDisplay().clone()).setRarity(rarity).build();
    }

    abstract String serialize();

    public BingoDifficulty getDifficulty() {
        return this.bingoDifficulty;
    }

    public void setDifficulty(BingoDifficulty bingoDifficulty) {
        this.bingoDifficulty = bingoDifficulty;
    }

    public T getObject() {
        return this.object;
    }

    public Class<?> getObjectClass() {
        return this.object.getClass();
    }

    public SerializedBingoObject<T> toSerializedBingoObject() {
        return new SerializedBingoObject(this);
    }

    public boolean hasFound(BingoTeam team) {
        return !team.getMissingBingoItems().contains(this);
    }

    @BingoData(key="bingo.object.item", icon=Material.DIAMOND)
    public static sealed class BingoItem
    extends BingoObject<ItemStack> {
        private static final long serialVersionUID = 1L;

        public BingoItem(ItemStack object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoItem(String object, BingoDifficulty bingoDifficulty) {
            this(ItemSerialization.itemStackFromBase64(object), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(ItemStack itemStack) {
            return itemStack.getType() == ((ItemStack)this.object).getType();
        }

        @Override
        public IChatMutableComponent getFoundVerb(@NotNull Player player) {
            return Translation.translate(player, "bingo.collected", new Object[0]);
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(((ItemStack)this.object).clone()).clearAttributes().build();
        }

        @Override
        public IChatMutableComponent getName() {
            return IChatBaseComponent.a((String)((ItemStack)this.object).getTranslationKey(), (String)new StringBuilder(((ItemStack)this.object).getType().name()).toNormalCase().build());
        }

        @Override
        public IChatMutableComponent getScoreboardIcon() {
            return BingoUtils.getItemIcon(((ItemStack)this.object).getType(), IChatBaseComponent.b((String)"-").a(EnumChatFormat.i));
        }

        @Override
        public boolean isEndObject() {
            return ItemList.endItems.contains(((ItemStack)this.object).getType());
        }

        @Override
        boolean compare(ItemStack object) {
            return object.getType() == ((ItemStack)this.object).getType();
        }

        @Override
        public boolean isNetherObject() {
            return ItemList.netherItems.contains(((ItemStack)this.object).getType());
        }

        @Override
        String serialize() {
            return ItemSerialization.itemStackToBase64((ItemStack)this.object);
        }

        public String toString() {
            return ((ItemStack)this.object).getType().name().toLowerCase();
        }

        @BingoData(key="bingo.object.enchantedItem", icon=Material.ENCHANTED_BOOK)
        public static final class EnchantedBingoItem
        extends BingoItem {
            public EnchantedBingoItem(ItemStack object, BingoDifficulty bingoDifficulty) {
                super(object, bingoDifficulty);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isSimilarObject(ItemStack itemStack) {
                if (itemStack.getType() != ((ItemStack)this.object).getType()) return false;
                if (((ItemStack)this.object).getEnchantments().keySet().stream().filter(arg_0 -> ((ItemStack)itemStack).containsEnchantment(arg_0)).count() != (long)((ItemStack)this.object).getEnchantments().size()) return false;
                return true;
            }
        }
    }

    @BingoData(key="bingo.object.advancement", icon=Material.PAPER)
    public static final class BingoAdvancement
    extends BingoObject<Advancement> {
        private static final long serialVersionUID = 1L;

        public BingoAdvancement(Advancement object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoAdvancement(String object, BingoDifficulty bingoDifficulty) {
            super(Bukkit.getAdvancement((NamespacedKey)NamespacedKey.minecraft((String)object)), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(Advancement advancement) {
            return ((Advancement)this.object).getKey().equals((Object)advancement.getKey());
        }

        @Override
        public IChatMutableComponent getFoundVerb(@NotNull Player player) {
            return Translation.translate(player, "bingo.completed", new Object[0]);
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(((Advancement)this.object).getDisplay().getIcon()).clearAttributes().setName((IChatBaseComponent)this.getName().a(EnumChatFormat.v)).setLore(new IChatBaseComponent[]{IChatBaseComponent.a((String)("advancements." + ((Advancement)this.object).getKey().getKey().replace("/", ".") + ".description"), (String)((Advancement)this.object).getDisplay().getDescription())}).flags().build();
        }

        @Override
        public IChatMutableComponent getName() {
            return IChatBaseComponent.a((String)("advancements." + ((Advancement)this.object).getKey().getKey().replace("/", ".") + ".title"), (String)((Advancement)this.object).getDisplay().getTitle());
        }

        @Override
        public IChatMutableComponent getScoreboardIcon() {
            MinecraftKey location = MinecraftKey.b((String)("sb/advancement/" + ((Advancement)this.object).getKey().getKey()));
            return IChatBaseComponent.a((ObjectInfo)new AtlasSprite(AtlasIds.g, location)).a(style -> style.b(EnumChatFormat.p.f().intValue()));
        }

        @Override
        public boolean isEndObject() {
            return AdvancementList.endAdvancements.stream().anyMatch(advancement -> advancement.getKey().getKey().equals(((Advancement)this.object).getKey().getKey()));
        }

        @Override
        boolean compare(Advancement object) {
            return object.getKey().getKey().equals(((Advancement)this.object).getKey().getKey());
        }

        @Override
        public boolean isNetherObject() {
            return AdvancementList.netherAdvancements.stream().anyMatch(advancement -> advancement.getKey().getKey().equals(((Advancement)this.object).getKey().getKey()));
        }

        @Override
        String serialize() {
            return ((Advancement)this.object).getKey().getKey();
        }

        public String toString() {
            return this.serialize();
        }
    }

    public static class SerializedBingoObject<T>
    implements Serializable {
        private final String object;
        private final BingoDifficulty difficulty;
        private final Class<BingoObject<T>> clazz;

        private SerializedBingoObject(BingoObject<T> toSerialize) {
            this.object = toSerialize.serialize();
            this.difficulty = toSerialize.getDifficulty();
            this.clazz = toSerialize.getClass();
        }

        public void toBingoObject() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            this.clazz.getConstructor(String.class, BingoDifficulty.class).newInstance(this.object, this.difficulty);
        }
    }

    @BingoData(key="bingo.object.entity", icon=Material.ZOMBIE_HEAD)
    public static final class BingoEntity
    extends BingoObject<EntityType> {
        private static final long serialVersionUID = 1L;

        public BingoEntity(EntityType object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoEntity(String object, BingoDifficulty bingoDifficulty) {
            super(EntityType.valueOf((String)object), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(EntityType entityType) {
            return this.object == entityType;
        }

        @Override
        public IChatMutableComponent getFoundVerb(@NotNull Player player) {
            return Translation.translate(player, "bingo.killed", new Object[0]);
        }

        @Override
        public ItemStack asDisplay() {
            ItemStack itemStack = new ItemBuilder(this.getMaterial()).clearAttributes().flags().build();
            net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            nmsItemStack.b(DataComponentMap.a().a(DataComponents.h, (Object)this.getName().a(EnumChatFormat.v)).a());
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
        }

        private Material getMaterial() {
            return switch ((EntityType)this.object) {
                case EntityType.PLAYER -> Material.PLAYER_HEAD;
                case EntityType.ARMOR_STAND -> Material.ARMOR_STAND;
                default -> Material.valueOf((String)(((EntityType)this.object).name() + "_SPAWN_EGG"));
            };
        }

        @Override
        public IChatMutableComponent getName() {
            return IChatBaseComponent.a((String)((EntityType)this.object).getTranslationKey(), (String)new StringBuilder(((EntityType)this.object).name()).toNormalCase().build());
        }

        @Override
        public IChatMutableComponent getScoreboardIcon() {
            return BingoUtils.getEntityIcon((EntityType)this.object, IChatBaseComponent.b((String)"-").a(EnumChatFormat.i));
        }

        @Override
        public boolean isEndObject() {
            return EntityList.endEntities.contains(this.object);
        }

        @Override
        boolean compare(EntityType object) {
            return object.name().contains(((EntityType)this.object).name());
        }

        @Override
        public boolean isNetherObject() {
            return EntityList.netherEntities.contains(this.object);
        }

        @Override
        String serialize() {
            return ((EntityType)this.object).name();
        }

        public String toString() {
            return this.serialize();
        }
    }

    @BingoData(key="bingo.object.structure", icon=Material.STRUCTURE_BLOCK)
    public static final class BingoStructure
    extends BingoObject<Structure> {
        private static final long serialVersionUID = 1L;

        public BingoStructure(Structure object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoStructure(String object, BingoDifficulty bingoDifficulty) {
            super((Structure)Registry.STRUCTURE.get(NamespacedKey.minecraft((String)object)), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(Structure structure) {
            return ((Structure)this.object).equals(structure);
        }

        @Override
        public IChatMutableComponent getFoundVerb(@NotNull Player player) {
            return Translation.translate(player, "found", new Object[0]);
        }

        @Override
        public ItemStack asDisplay() {
            return new ItemBuilder(((Structure)this.object).getStructureType() == StructureType.STRONGHOLD ? Material.ENDER_EYE : StructureList.structureMap.getOrDefault(this.object, Material.STRUCTURE_BLOCK)).setName((IChatBaseComponent)IChatBaseComponent.b((String)new StringBuilder(((Structure)this.object).getKeyOrThrow().getKey()).toNormalCase().build()).a(EnumChatFormat.v)).clearAttributes().flags().build();
        }

        @Override
        public IChatMutableComponent getName() {
            return IChatBaseComponent.b((String)new StringBuilder(((Structure)this.object).getKeyOrThrow().getKey()).toNormalCase().build());
        }

        @Override
        public IChatMutableComponent getScoreboardIcon() {
            NamespacedKey key = ((Structure)this.object).getKeyOrNull();
            return key == null ? IChatBaseComponent.b((String)"-").a(EnumChatFormat.i) : IChatBaseComponent.a((ObjectInfo)new AtlasSprite(AtlasIds.g, MinecraftKey.b((String)("sb/structure/" + key.getKey().toLowerCase())))).a(style -> style.b(EnumChatFormat.p.f().intValue()));
        }

        @Override
        public boolean isEndObject() {
            return StructureList.endStructures.stream().anyMatch(structure -> structure.getKeyOrThrow().getKey().equals(((Structure)this.object).getKeyOrThrow().getKey()));
        }

        @Override
        boolean compare(Structure object) {
            return object.getKeyOrThrow().getKey().equals(((Structure)this.object).getKeyOrThrow().getKey());
        }

        @Override
        public boolean isNetherObject() {
            return StructureList.netherStructures.stream().anyMatch(structure -> structure.getKeyOrThrow().getKey().equals(((Structure)this.object).getKeyOrThrow().getKey()));
        }

        @Override
        String serialize() {
            return ((Structure)this.object).getKeyOrThrow().getKey();
        }

        public String toString() {
            return this.serialize();
        }
    }

    @BingoData(key="bingo.object.biome", icon=Material.GRASS_BLOCK)
    public static final class BingoBiome
    extends BingoObject<Biome> {
        private static final long serialVersionUID = 1L;

        public BingoBiome(Biome object, BingoDifficulty bingoDifficulty) {
            super(object, bingoDifficulty);
        }

        public BingoBiome(String object, BingoDifficulty bingoDifficulty) throws NoSuchFieldException, IllegalAccessException {
            super((Biome)Biome.class.getDeclaredField(object.toUpperCase()).get(null), bingoDifficulty);
        }

        @Override
        public boolean isSimilarObject(Biome biome) {
            return this.object == biome;
        }

        @Override
        public IChatMutableComponent getFoundVerb(@NotNull Player player) {
            return Translation.translate(player, "bingo.discovered", new Object[0]);
        }

        @Override
        public ItemStack asDisplay() {
            ItemStack itemStack = new ItemBuilder(BiomeList.biomeMap.getOrDefault(this.object, Material.GRASS_BLOCK)).clearAttributes().flags().build();
            net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            nmsItemStack.b(DataComponentMap.a().a(DataComponents.h, (Object)this.getName().a(EnumChatFormat.v)).a());
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
        }

        @Override
        public IChatMutableComponent getName() {
            return IChatBaseComponent.a((String)("biome.minecraft." + ((Biome)this.object).getKeyOrThrow().getKey()), (String)new StringBuilder(((CraftBiome)this.object).name()).toNormalCase().build());
        }

        @Override
        public IChatMutableComponent getScoreboardIcon() {
            NamespacedKey key = ((Biome)this.object).getKeyOrNull();
            return key == null ? IChatBaseComponent.b((String)"-").a(EnumChatFormat.i) : IChatBaseComponent.a((ObjectInfo)new AtlasSprite(AtlasIds.g, MinecraftKey.b((String)("sb/biome/" + key.getKey().toLowerCase())))).a(style -> style.b(EnumChatFormat.p.f().intValue()));
        }

        @Override
        public boolean isEndObject() {
            return BiomeList.endBiomes.contains(this.object);
        }

        @Override
        boolean compare(Biome object) {
            return object.getKeyOrThrow().getKey().equals(((Biome)this.object).getKeyOrThrow().getKey());
        }

        @Override
        public boolean isNetherObject() {
            return BiomeList.netherBiomes.contains(this.object);
        }

        @Override
        String serialize() {
            return ((CraftBiome)this.object).name().toUpperCase();
        }

        public String toString() {
            return this.serialize();
        }
    }
}

