/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.List;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class AmountOfObjectsSetting
extends BingoSetting<Integer> {
    AmountOfObjectsSetting() {
    }

    @Override
    public Integer getDefaultValue() {
        return 9;
    }

    @Override
    public ItemBuilder getIcon(@NotNull Player player) {
        return new ItemBuilder(Material.CHEST).setName((IChatBaseComponent)Translation.translate(player, "options.amountOfObjects.title", new Object[0]).a(style -> style.a(EnumChatFormat.o).b(Boolean.valueOf(false)))).setLore(Translation.value(player, String.valueOf(ChatColor.GOLD) + String.valueOf(this.getValue()), EnumChatFormat.h)).addLore(this.getDescription(player, true)).setClickHandler("amount-of-objects", event -> {
            if (event.getClick().isLeftClick()) {
                this.setValue((Integer)this.getValue() + 1);
            } else if (event.getClick().isRightClick()) {
                if ((Integer)this.getValue() > 1) {
                    this.setValue((Integer)this.getValue() - 1);
                } else {
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
            }
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            List<IChatBaseComponent> lore = ItemBuilder.getLore(currentItem);
            lore.set(0, Translation.value(player, String.valueOf(ChatColor.GOLD) + String.valueOf(this.getValue()), EnumChatFormat.h));
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, lore).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public IChatBaseComponent getSettingsText(@NotNull Player player) {
        return Translation.translate(player, "options.amountOfObjects.title", new Object[0]).a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))).f(": " + String.valueOf(ChatColor.BLUE) + String.valueOf(this.getValue()));
    }

    @Override
    public int getSlot() {
        return 24;
    }

    @Override
    public List<Pair<String, Boolean>> getDescriptionKeys() {
        return List.of(Pair.of((Object)"options.amountOfObjects.description.1", (Object)false), Pair.of((Object)"options.amountOfObjects.description.2", (Object)false), Pair.of((Object)"options.amountOfObjects.description.3", (Object)true), Pair.of((Object)"options.amountOfObjects.description.4", (Object)true));
    }
}

