/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.BingoDifficulty;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class DifficultySetting
extends BingoSetting<BingoDifficulty> {
    DifficultySetting() {
    }

    @Override
    public BingoDifficulty getDefaultValue() {
        return BingoDifficulty.NORMAL;
    }

    @Override
    public ItemBuilder getIcon(@NotNull Player player) {
        return new ItemBuilder(Material.BEACON).setName((IChatBaseComponent)Translation.translate(player, "options.difficulty.title", new Object[0]).a(style -> style.a(EnumChatFormat.o).b(Boolean.valueOf(false)))).setLore(this.getLore(player).toArray(new IChatBaseComponent[0])).addLore(this.getDescription(player, true)).setClickHandler("difficulty", event -> {
            this.setValue(event.getClick().isLeftClick() ? ((BingoDifficulty)this.getValue()).next(false) : ((BingoDifficulty)this.getValue()).prev(false));
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, Stream.concat(this.getLore((Player)event.getWhoClicked()).stream(), Arrays.stream(this.getDescription((Player)event.getWhoClicked(), true))).toList()).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public IChatBaseComponent getSettingsText(@NotNull Player player) {
        return Translation.translate(player, "options.difficulty.title", new Object[0]).a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))).b((IChatBaseComponent)IChatBaseComponent.b((String)": ").b((IChatBaseComponent)((BingoDifficulty)this.getValue()).getName(player)));
    }

    private List<IChatBaseComponent> getLore(@NotNull Player player) {
        return Arrays.stream(BingoDifficulty.getAll()).map(bingoDifficulty -> this.getValue() == bingoDifficulty ? bingoDifficulty.getName(player) : bingoDifficulty.getName(player).a(EnumChatFormat.h)).toList();
    }

    @Override
    public int getSlot() {
        return 33;
    }

    @Override
    public List<Pair<String, Boolean>> getDescriptionKeys() {
        return List.of(Pair.of((Object)"options.difficulty.description.1", (Object)false), Pair.of((Object)"options.difficulty.description.2", (Object)false));
    }

    @Override
    public Object serialize(BingoDifficulty bingoDifficulty) {
        return bingoDifficulty.name();
    }

    @Override
    public BingoDifficulty deserialize(Object o) {
        return BingoDifficulty.valueOf(o.toString());
    }
}

