/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.Var;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.config.Configuration;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class ObjectTypesSetting
extends BingoSetting<Map<Class<? extends BingoObject<?>>, Integer>> {
    private int cursorIndex = 0;

    ObjectTypesSetting() {
    }

    @Override
    public Map<Class<? extends BingoObject<?>>, Integer> getDefaultValue() {
        return Arrays.stream(BingoObject.getClasses()).collect(Collectors.toMap(clazz -> clazz, clazz -> 1));
    }

    @Override
    public ItemBuilder getIcon(@NotNull Player player) {
        return new ItemBuilder(Material.WRITABLE_BOOK).setName((IChatBaseComponent)Translation.translate(player, "options.objectTypes.title", new Object[0]).a(style -> style.a(EnumChatFormat.o).b(Boolean.valueOf(false)))).setLore(this.getLore(this.cursorIndex, player).toArray(new IChatBaseComponent[0])).addLore(this.getDescription(player, true)).setClickHandler("object-types", event -> {
            if (event.getClick().isLeftClick()) {
                this.cursorIndex = (this.cursorIndex + 1) % BingoObject.getClasses().length;
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.UI_BUTTON_CLICK, 100.0f, 1.5f);
            } else {
                Class<BingoObject<?>> selectedValue;
                HashMap currentMap = new HashMap((Map)this.getValue());
                int currentValue = currentMap.getOrDefault(selectedValue = BingoObject.getClasses()[this.cursorIndex], 0);
                currentValue = currentValue == 10 ? 0 : ++currentValue;
                currentMap.put(selectedValue, currentValue);
                this.setValue(currentMap);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            }
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, Stream.concat(this.getLore(this.cursorIndex, (Player)event.getWhoClicked()).stream(), Arrays.stream(this.getDescription(player, true))).toList()).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    private List<IChatBaseComponent> getLore(int cursorIndex, @NotNull Player player) {
        ArrayList<IChatMutableComponent> lore = new ArrayList<IChatMutableComponent>(Arrays.stream(BingoObject.getClasses()).map(aClass -> BingoObject.getName(player, aClass).a(style -> style.a(EnumChatFormat.j)).b((IChatBaseComponent)IChatBaseComponent.b((String)" - ").a(style -> style.a(EnumChatFormat.h)).b(((Map)this.getValue()).getOrDefault(aClass, 0) != 0 ? Translation.ENABLED(player) : Translation.DISABLED(player)).b((IChatBaseComponent)IChatBaseComponent.b((String)(" " + String.valueOf(((Map)this.getValue()).getOrDefault(aClass, 0)))).a(style -> style.a(EnumChatFormat.h))))).toList());
        lore.set(cursorIndex, IChatBaseComponent.b((String)"> ").a(style -> style.a(EnumChatFormat.h)).b((IChatBaseComponent)lore.get(cursorIndex)));
        return lore;
    }

    @Override
    public IChatBaseComponent getSettingsText(@NotNull Player player) {
        IChatMutableComponent component = Translation.translate(player, "options.objectTypes.title", new Object[0]).a(style -> style.a(EnumChatFormat.h).b(Boolean.valueOf(false))).b((IChatBaseComponent)IChatBaseComponent.b((String)": "));
        List<Class> classes = Arrays.stream(BingoObject.getClasses()).filter(aClass -> ((Map)this.getValue()).getOrDefault(aClass, 0) != 0).toList();
        for (int i = 0; i < classes.size(); ++i) {
            if (i != 0) {
                component = component.b((IChatBaseComponent)IChatBaseComponent.b((String)", ").a(style -> style.a(EnumChatFormat.h)));
            }
            component = component.b((IChatBaseComponent)BingoObject.getName(player, classes.get(i)).a(style -> style.a(EnumChatFormat.j)));
        }
        return component;
    }

    @Override
    public int getSlot() {
        return 42;
    }

    @Override
    public List<Pair<String, Boolean>> getDescriptionKeys() {
        return List.of(Pair.of((Object)"options.objectTypes.description.1", (Object)false), Pair.of((Object)"options.objectTypes.description.2", (Object)true), Pair.of((Object)"options.objectTypes.description.3", (Object)true));
    }

    @Override
    public void setValue(Map<Class<? extends BingoObject<?>>, Integer> classIntegerMap) {
        map.put(this, classIntegerMap);
        Configuration.MyConfig config = new Configuration(Main.plugin.getDataFolder(), "BingoSettings.yml").getConfig();
        classIntegerMap.keySet().forEach(aClass -> config.set(this.getClass().getSimpleName() + "." + aClass.getName(), classIntegerMap.get(aClass)));
    }

    @Override
    public Map<Class<? extends BingoObject<?>>, Integer> deserialize(Object o) {
        Configuration.MyConfig config = new Configuration(Main.plugin.getDataFolder(), "BingoSettings.yml").getConfig();
        ConfigurationSection section = config.getConfig().getConfigurationSection(this.getClass().getSimpleName());
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        for (String key : section.getKeys(true)) {
            if (!(section.get(key) instanceof Integer)) continue;
            try {
                map.put((Class)Var.unsafeCast(Class.forName(key)), section.getInt(key));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        BingoSetting.map.put(this, map);
        return null;
    }
}

