/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.listener.SettingsListener;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class ServerRestartSetting
extends BingoSetting<Integer> {
    ServerRestartSetting() {
    }

    @Override
    public Integer getDefaultValue() {
        return 30;
    }

    @Override
    public ItemBuilder getIcon(@NotNull Player player) {
        return new ItemBuilder(Material.COMPARATOR).setName((IChatBaseComponent)Translation.translate(player, "options.restart.title", new Object[0]).a(style -> style.a(EnumChatFormat.m).b(Boolean.valueOf(false)))).setLore(this.getLore(player).toArray(new IChatBaseComponent[0])).setClickHandler("server-restart", event -> {
            if (event.getClick().isLeftClick()) {
                this.setValue((Integer)this.getValue() + 15);
            } else if (event.getClick().isRightClick()) {
                if ((long)((Integer)this.getValue()).intValue() > 0L) {
                    this.setValue((Integer)this.getValue() - 15);
                } else {
                    ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 0.75f);
                    return;
                }
            }
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            ItemStack currentItem = event.getCurrentItem();
            currentItem.setItemMeta(ItemBuilder.setLore(currentItem, this.getLore((Player)event.getWhoClicked())).getItemMeta());
            SettingsListener.updateInventory(event);
        });
    }

    @Override
    public IChatBaseComponent getSettingsText(@NotNull Player player) {
        return null;
    }

    @Override
    public int getSlot() {
        return 4;
    }

    private List<IChatBaseComponent> getLore(@NotNull Player player) {
        return Stream.concat(Stream.of(Translation.value(player, (long)((Integer)this.getValue()).intValue() == 0L ? Translation.translate(player, "options.manually", new Object[0]) : Translation.translate(player, "options.sec", this.getValue()).a(style -> style.a(EnumChatFormat.j).b(Boolean.valueOf(false))), EnumChatFormat.h)), Arrays.stream(this.getDescription(player, true))).toList();
    }

    @Override
    public List<Pair<String, Boolean>> getDescriptionKeys() {
        return List.of(Pair.of((Object)"options.restart.description.1", (Object)false), Pair.of((Object)"options.restart.description.2", (Object)false), Pair.of((Object)"options.restart.description.3", (Object)false), Pair.of((Object)"options.restart.description.4", (Object)true), Pair.of((Object)"options.restart.description.5", (Object)true));
    }
}

