/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.lang.Translation;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public non-sealed class BackpackCommand
extends AbstractCommand {
    public BackpackCommand() {
        super("backpack", "command.backpack.description");
        this.withPermission("bingo");
        this.withAliases("bp");
        this.withFullDescription("Opens your team's backpack");
        this.executesPlayer((Player player, CommandArguments commandArguments) -> {
            Optional<BingoTeam> optionalTeam = BingoTeam.getTeam(player.getUniqueId());
            if (optionalTeam.isEmpty()) {
                BingoUtils.sendMessage((HumanEntity)player, (IChatBaseComponent)Translation.translate(player, "team.none", new Object[0]).a(EnumChatFormat.m), true);
                return;
            }
            new InventoryBuilder(optionalTeam.get().getBackpack()).openAsNMS((HumanEntity)player, (IChatBaseComponent)Translation.translate(player, "team.backpack", new Object[0]));
        });
        this.register();
    }
}

