/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import de.eisi05.bingo.utils.lang.Translation;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class BingoCommand
extends AbstractCommand
implements InventoryHolder {
    public BingoCommand() {
        super("bingo", "command.bingo.description");
        this.withPermission("bingo");
        this.withFullDescription("Opens the bingo board");
        this.executesPlayer((Player player, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)player, (IChatBaseComponent)Translation.translate(player, "game.none", new Object[0]).a(EnumChatFormat.m), true);
                return;
            }
            player.openInventory(this.getBingoInventory(BingoTeam.getTeam(player.getUniqueId()).orElse(null), player));
        });
        ((CommandAPICommand)this.withOptionalArguments(new Argument[]{(Argument)((Argument)new StringArgument("team").withRequirement(commandSender -> {
            Player player;
            return commandSender instanceof Player && BingoTeam.getTeam((player = (Player)commandSender).getUniqueId()).isEmpty();
        })).replaceSuggestions(ArgumentSuggestions.stringsAsync(commandSenderSuggestionInfo -> CompletableFuture.supplyAsync(() -> (String[])BingoTeam.teams.stream().map(team -> "" + team.getId()).toArray(String[]::new))))})).executesPlayer((Player sender, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)sender, (IChatBaseComponent)Translation.translate(sender, "game.none", new Object[0]).a(EnumChatFormat.m), true);
                return;
            }
            Optional<BingoTeam> team = BingoTeam.getTeam(sender.getUniqueId());
            team.ifPresentOrElse(team1 -> sender.openInventory(this.getBingoInventory((BingoTeam)team1, sender)), () -> {
                String current = args.getRaw("team");
                BingoTeam.teams.stream().filter(team1 -> ("" + team1.getId()).equals(current)).findFirst().ifPresentOrElse(team1 -> sender.openInventory(this.getBingoInventory((BingoTeam)team1, sender)), () -> BingoUtils.sendMessage((HumanEntity)sender, (IChatBaseComponent)Translation.translate(sender, "team.not-found", new Object[0]).a(EnumChatFormat.m), true));
            });
        });
        this.register();
    }

    private Inventory getBingoInventory(@Nullable BingoTeam team, @NotNull Player player) {
        LinkedList<ItemStack> items;
        int selectedSize = BingoObject.getSelectedObjects().size();
        LinkedList<ItemStack> linkedList = items = team == null ? BingoTeam.getDefaultBingoItems(null, player) : team.getBingoItems(player);
        if (selectedSize <= 5) {
            InventoryBuilder builder = new InventoryBuilder((InventoryHolder)this, InventoryType.HOPPER, "Bingo");
            for (int i = 0; i < items.size(); ++i) {
                builder.setItem(i, (ItemStack)items.get(i));
            }
            return builder.normal().build();
        }
        if (selectedSize == 9) {
            InventoryBuilder builder = new InventoryBuilder((InventoryHolder)this, InventoryType.DROPPER, "Bingo");
            for (int i = 0; i < items.size(); ++i) {
                builder.setItem(i, (ItemStack)items.get(i));
            }
            return builder.normal().build();
        }
        int maxInvSize = 54;
        if (selectedSize < maxInvSize) {
            int invSize = (selectedSize + 8) / 9 * 9;
            InventoryBuilder builder = new InventoryBuilder((InventoryHolder)this, invSize, "Bingo");
            for (int i = 0; i < items.size(); ++i) {
                builder.setItem(i, (ItemStack)items.get(i));
            }
            return builder.normal().build();
        }
        return new ScrollInventory(this, IChatBaseComponent.b((String)"Bingo"), items, true, new ScrollInventory.Hotbar[0]).setArrowBackEvent("bingo-back", event -> event.getWhoClicked().closeInventory()).start();
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }
}

