/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.game;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.ObjectTypesSetting;
import de.eisi05.bingo.bingo.settings.ServerRestartSetting;
import de.eisi05.bingo.bingo.settings.TimeSetting;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.game.GameActionBar;
import de.eisi05.bingo.listener.CollectAdvancementListener;
import de.eisi05.bingo.listener.CollectBiomeListener;
import de.eisi05.bingo.listener.CollectEntityListener;
import de.eisi05.bingo.listener.CollectItemListener;
import de.eisi05.bingo.listener.CollectStructureListener;
import de.eisi05.bingo.manager.PlacementManager;
import de.eisi05.bingo.manager.PlayerSessionManager;
import de.eisi05.bingo.manager.ScoreboardManager;
import de.eisi05.bingo.manager.VoteManager;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.RestartFile;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.lang.LocalizationManager;
import de.eisi05.bingo.utils.lang.Translation;
import de.eisi05.bingo.world.WorldGeneration;
import de.eisi05.bingo.world.WorldManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;

public enum GameState {
    LOBBY{

        @Override
        public GameState run() {
            return this;
        }
    }
    ,
    TEAM_SELECT{

        @Override
        public GameState run() {
            new BukkitRunnable(this){

                public void run() {
                    Bukkit.getLogger().info("Calculating objects for the game...");
                    BingoObject.calculateNewSelectedObjects();
                    Bukkit.getLogger().info("Calculating done!");
                }
            }.runTaskLaterAsynchronously(Main.plugin, 10L);
            BingoTeam.createBingoTeams();
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.setScoreboard(ScoreboardManager.createScoreboard());
                player.getInventory().setItem(8, BingoUtils.teamSelectItem(player));
                if (!player.isOp()) continue;
                player.getInventory().setItem(4, BingoUtils.startItem.apply(player));
            }
            return this;
        }
    }
    ,
    STARTING{

        @Override
        public GameState run() {
            Bukkit.broadcastMessage((String)"\n\n");
            Bukkit.broadcastMessage((String)(String.valueOf(org.bukkit.ChatColor.DARK_GRAY) + " ".repeat(7) + "--- " + Prefix.SERVER + String.valueOf(org.bukkit.ChatColor.DARK_GRAY) + "---" + " ".repeat(7)));
            Consumer<Player> commandMessage = player -> Arrays.stream(BingoSetting.values()).filter(bingoSetting -> bingoSetting.getSettingsText((Player)player) != null).sorted((o1, o2) -> {
                boolean isO1TimeSetting = o1.getClass().equals(TimeSetting.class);
                boolean isO2TimeSetting = o2.getClass().equals(TimeSetting.class);
                if (isO1TimeSetting && isO2TimeSetting) {
                    return 0;
                }
                if (isO1TimeSetting) {
                    return 1;
                }
                if (isO2TimeSetting) {
                    return -1;
                }
                boolean isO1Boolean = o1.getDefaultValue().getClass().equals(Boolean.class);
                boolean isO2Boolean = o2.getDefaultValue().getClass().equals(Boolean.class);
                if (isO1Boolean && isO2Boolean) {
                    return 0;
                }
                if (isO1Boolean) {
                    return -1;
                }
                if (isO2Boolean) {
                    return 1;
                }
                return 0;
            }).forEach(bingoSetting -> ((CraftPlayer)player).getHandle().a(bingoSetting.getSettingsText((Player)player)));
            for (Player player2 : Bukkit.getOnlinePlayers()) {
                player2.getInventory().clear();
                commandMessage.accept(player2);
            }
            new BukkitRunnable(this){
                final int startCounter = 15;
                int counter = 15;

                public void run() {
                    Bukkit.getOnlinePlayers().forEach(player -> {
                        player.setLevel(this.counter);
                        player.setExp((float)this.counter / 15.0f);
                    });
                    if (this.counter <= 0) {
                        this.cancel();
                        GameState.setGameState(INGAME);
                        BingoUtils.voteManager = new VoteManager();
                        for (Player player2 : Bukkit.getOnlinePlayers()) {
                            BingoUtils.sendTitle((HumanEntity)player2, (IChatBaseComponent)Translation.translate(player2, "game.time.go", new Object[0]).a(EnumChatFormat.c), (IChatBaseComponent)IChatBaseComponent.i(), 0, 50, 0);
                            player2.playSound((Entity)player2, Sound.ENTITY_ENDER_DRAGON_GROWL, 100.0f, 1.0f);
                        }
                    } else if (this.counter == 15 || this.counter == 10 || this.counter <= 5) {
                        org.bukkit.ChatColor color = switch (this.counter) {
                            case 5 -> org.bukkit.ChatColor.DARK_RED;
                            case 4 -> org.bukkit.ChatColor.RED;
                            case 3 -> org.bukkit.ChatColor.GOLD;
                            case 2 -> org.bukkit.ChatColor.YELLOW;
                            case 1 -> org.bukkit.ChatColor.GREEN;
                            default -> org.bukkit.ChatColor.BLUE;
                        };
                        for (Player player3 : Bukkit.getOnlinePlayers()) {
                            IChatMutableComponent message = Translation.translate(player3, "game.time.start.chat", String.valueOf(color) + this.counter).a(EnumChatFormat.h);
                            BingoUtils.sendMessage((HumanEntity)player3, (IChatBaseComponent)message, true);
                            player3.playSound(player3.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 100.0f, 1.0f);
                            if (this.counter > 5 || this.counter <= 0) continue;
                            BingoUtils.sendTitle((HumanEntity)player3, (IChatBaseComponent)Translation.translate(player3, "game.time.start.title", new Object[0]).a(EnumChatFormat.h), (IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(this.counter)).a(EnumChatFormat.a((char)color.getChar())), 0, 50, 0);
                        }
                    }
                    --this.counter;
                }
            }.runTaskTimer(Main.plugin, 0L, 20L);
            return this;
        }
    }
    ,
    INGAME{

        @Override
        public GameState run() {
            if (((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).getOrDefault(BingoObject.BingoItem.class, 0) != 0) {
                Bukkit.getPluginManager().registerEvents((Listener)new CollectItemListener(), Main.plugin);
            }
            if (((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).getOrDefault(BingoObject.BingoBiome.class, 0) != 0) {
                Bukkit.getPluginManager().registerEvents((Listener)new CollectBiomeListener(), Main.plugin);
            }
            if (((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).getOrDefault(BingoObject.BingoAdvancement.class, 0) != 0) {
                Bukkit.getPluginManager().registerEvents((Listener)new CollectAdvancementListener(), Main.plugin);
            }
            if (((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).getOrDefault(BingoObject.BingoEntity.class, 0) != 0) {
                Bukkit.getPluginManager().registerEvents((Listener)new CollectEntityListener(), Main.plugin);
            }
            if (((Map)BingoSetting.getSetting(ObjectTypesSetting.class).getValue()).getOrDefault(BingoObject.BingoStructure.class, 0) != 0) {
                Bukkit.getPluginManager().registerEvents((Listener)new CollectStructureListener(), Main.plugin);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                TextComponent translatableComponent = new TextComponent(LocalizationManager.get(player, "misc.commands", new Object[0]));
                translatableComponent.setColor(ChatColor.GRAY);
                BaseComponent baseComponent = TextComponent.fromLegacy((String)("\n\n" + Prefix.SERVER + String.valueOf(org.bukkit.ChatColor.DARK_GRAY) + " --- "));
                BaseComponent endComponent = TextComponent.fromLegacy((String)(String.valueOf(org.bukkit.ChatColor.DARK_GRAY) + " ---"));
                translatableComponent.addExtra(endComponent);
                baseComponent.addExtra((BaseComponent)translatableComponent);
                Bukkit.spigot().broadcast(baseComponent);
                AbstractCommand.getCommands().forEach(abstractCommand -> {
                    IChatMutableComponent component = IChatBaseComponent.b((String)("/" + abstractCommand.getName() + (String)(abstractCommand.getAliases().length > 0 ? " | " + String.join((CharSequence)" | ", abstractCommand.getAliases()) : ""))).a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" >> ").a(EnumChatFormat.i).b((IChatBaseComponent)Translation.translate(player, abstractCommand.getDescriptionKey(), new Object[0]).a(EnumChatFormat.k)));
                    ((CraftServer)Bukkit.getServer()).getHandle().broadcastMessage(new IChatBaseComponent[]{component});
                });
            }
            time = (Integer)BingoSetting.getSetting(TimeSetting.class).getValue() == 0 ? System.currentTimeMillis() : System.currentTimeMillis() + (long)((Integer)BingoSetting.getSetting(TimeSetting.class).getValue() * 60 * 1000);
            BingoTeam.teams.removeIf(team -> team.getPlayers().isEmpty());
            WorldGeneration.removeWalls(WorldManager.overworld);
            WorldManager.overworld.setDifficulty(Difficulty.NORMAL);
            WorldManager.overworld.setTime(1200L);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.addAttachment(Main.plugin, "bingo", true);
                player.recalculatePermissions();
                player.updateCommands();
                ScoreboardManager.updateScoreboard(player);
                if (BingoTeam.getTeam(player.getUniqueId()).isEmpty()) {
                    player.setGameMode(GameMode.SPECTATOR);
                    BingoTeam.addPlayerToSpectator((HumanEntity)player);
                } else {
                    player.setGameMode(GameMode.SURVIVAL);
                }
                player.getInventory().clear();
                player.setHealth(20.0);
                player.setLevel(0);
                player.setExp(0.0f);
                player.setSaturation(10.0f);
                player.setFoodLevel(20);
                Objective objective = player.getScoreboard().registerNewObjective("objectCount", Criteria.DUMMY, "Object Count");
                objective.setDisplaySlot(DisplaySlot.PLAYER_LIST);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    objective.getScore(p.getName()).setScore(0);
                }
            }
            task = new BukkitRunnable(this){
                int counter = 0;

                public void run() {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        ScoreboardManager.updateTime(player);
                    }
                    if ((Integer)BingoSetting.getSetting(TimeSetting.class).getValue() != 0 && time - System.currentTimeMillis() <= 0L) {
                        GameState.setGameState(FINISH);
                        this.cancel();
                    }
                    if (this.counter % 5 == 0) {
                        BingoTeam.teams.forEach(BingoTeam::updateAdvancementProgresses);
                    }
                    ++this.counter;
                }
            }.runTaskTimer(Main.plugin, 0L, 10L);
            return this;
        }
    }
    ,
    FINISH{

        @Override
        public GameState run() {
            GameActionBar.enable();
            if (task != null && !task.isCancelled() && (Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId()) || Bukkit.getScheduler().isQueued(task.getTaskId()))) {
                task.cancel();
            }
            List<BingoTeam> winner = PlacementManager.getFirstPlace();
            String winnerTeams = String.join((CharSequence)(String.valueOf(org.bukkit.ChatColor.GRAY) + ", "), winner.stream().map(BingoTeam::getNameAsString).toList());
            BaseComponent prefix = TextComponent.fromLegacy((String)("\n".repeat(5) + Prefix.SERVER));
            BaseComponent winnerTeamsComponent = null;
            for (int i = 0; i < winner.size(); ++i) {
                BingoTeam bingoTeam = winner.get(i);
                BaseComponent team2 = TextComponent.fromLegacy((String)bingoTeam.getNameAsString());
                team2.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(String.valueOf(bingoTeam.getColor()) + String.join((CharSequence)", ", bingoTeam.getPlayers().stream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid).getName()).toList()))}));
                if (i + 1 != winner.size()) {
                    team2.addExtra(TextComponent.fromLegacy((String)(String.valueOf(org.bukkit.ChatColor.GRAY) + ", ")));
                }
                if (winnerTeamsComponent == null) {
                    winnerTeamsComponent = team2;
                    continue;
                }
                winnerTeamsComponent.addExtra(team2);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                TextComponent winnerComponent = new TextComponent(LocalizationManager.get(player, "game.won", winnerTeamsComponent.toLegacyText()));
                winnerComponent.setColor(ChatColor.GOLD);
                prefix.addExtra((BaseComponent)winnerComponent);
                BaseComponent seedPrefix = TextComponent.fromLegacy((String)("\n" + Prefix.SERVER));
                TextComponent seed = new TextComponent(LocalizationManager.get(player, "misc.seed", WorldManager.overworld.getSeed()));
                seed.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, String.valueOf(WorldManager.overworld.getSeed())));
                seed.setColor(ChatColor.GREEN);
                BaseComponent seedSuffix = TextComponent.fromLegacy((String)"\n");
                prefix.addExtra(seedPrefix);
                prefix.addExtra((BaseComponent)seed);
                prefix.addExtra(seedSuffix);
                player.spigot().sendMessage(ChatMessageType.CHAT, prefix);
                player.playSound((Entity)player, Sound.UI_TOAST_CHALLENGE_COMPLETE, 100.0f, 1.0f);
                if (winner.stream().anyMatch(team -> team.getPlayers().contains(player.getUniqueId()))) {
                    BingoUtils.sendTitle((HumanEntity)player, (IChatBaseComponent)Translation.translate(player, "game.you.won", new Object[0]).a(EnumChatFormat.g), (IChatBaseComponent)Translation.translate(player, "game.congratulations", new Object[0]).a(EnumChatFormat.k), 20, 500, 20);
                    continue;
                }
                BingoUtils.sendTitle((HumanEntity)player, (IChatBaseComponent)Translation.translate(player, "game.over", new Object[0]).a(EnumChatFormat.m), (IChatBaseComponent)Translation.translate(player, "game.won", winnerTeams).a(EnumChatFormat.g), 5, 500, 5);
            }
            restartTime = (Integer)BingoSetting.getSetting(ServerRestartSetting.class).getValue() == 0 ? -1L : System.currentTimeMillis() + (long)((Integer)BingoSetting.getSetting(ServerRestartSetting.class).getValue() * 1000);
            return this;
        }
    }
    ,
    RESTART{

        @Override
        public GameState run() {
            PlayerSessionManager.clearPlayerData();
            Bukkit.getOnlinePlayers().forEach(player -> ((CraftPlayer)player).getHandle().g.a((IChatBaseComponent)Translation.translate(player, "game.restart.title", new Object[0]).a(EnumChatFormat.m)));
            RestartFile.create();
            Bukkit.getScheduler().scheduleSyncDelayedTask(Main.plugin, () -> Bukkit.getServer().spigot().restart(), 5L);
            return this;
        }
    };

    public static GameState currentGameState;
    public static long time;
    public static long restartTime;
    private static BukkitTask task;

    public static void setGameState(GameState gameState) {
        currentGameState = gameState.run();
    }

    public abstract GameState run();

    static {
        currentGameState = LOBBY.run();
    }
}

