/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import com.mojang.brigadier.Message;
import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.DamageSetting;
import de.eisi05.bingo.bingo.settings.EndSetting;
import de.eisi05.bingo.bingo.settings.KeepInventorySetting;
import de.eisi05.bingo.bingo.settings.NetherSetting;
import de.eisi05.bingo.bingo.settings.PVPSetting;
import de.eisi05.bingo.bingo.settings.RandomizerSetting;
import de.eisi05.bingo.bingo.settings.SaturationSetting;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.RandomizeManager;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.config.ItemConfiguration;
import de.eisi05.bingo.world.WorldManager;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public class GameListener
implements Listener {
    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
            return;
        }
        if (((Boolean)BingoSetting.getSetting(RandomizerSetting.class).getValue()).booleanValue()) {
            event.setDropItems(false);
            RandomizeManager.getItems(event.getBlock().getType()).forEach(material -> event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), new ItemStack(material)));
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (event.getDamageSource().getCausingEntity() instanceof Player) {
            return;
        }
        if (!((Boolean)BingoSetting.getSetting(DamageSetting.class).getValue()).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (GameState.currentGameState != GameState.INGAME) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!((Boolean)BingoSetting.getSetting(DamageSetting.class).getValue()).booleanValue() && !(event.getDamager() instanceof Player)) {
            event.setCancelled(true);
        }
        if (!((Boolean)BingoSetting.getSetting(PVPSetting.class).getValue()).booleanValue() && event.getDamager() instanceof Player) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortal(PlayerPortalEvent event) {
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL && !((Boolean)BingoSetting.getSetting(EndSetting.class).getValue()).booleanValue()) {
            event.setCancelled(true);
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL && !((Boolean)BingoSetting.getSetting(NetherSetting.class).getValue()).booleanValue()) {
            event.setCancelled(true);
        }
        if (event.getTo().getWorld().getName().equals("world")) {
            Location loc = event.getTo();
            loc.setWorld(WorldManager.overworld);
            event.setTo(loc);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        EntityPlayer player = ((CraftPlayer)event.getEntity()).getHandle();
        IChatBaseComponent message = player.fh().a();
        event.setDeathMessage(null);
        ComponentContents componentContents = message.b();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            CraftServer server = (CraftServer)Bukkit.getServer();
            IChatMutableComponent prefix = IChatBaseComponent.b((String)"[").a(EnumChatFormat.i).b((IChatBaseComponent)Main.bingoPrefixComponent.f().b((IChatBaseComponent)IChatBaseComponent.b((String)"] ").a(EnumChatFormat.i)));
            IChatMutableComponent playerName = IChatBaseComponent.b((String)"[").a(EnumChatFormat.h).b((IChatBaseComponent)BingoTeam.getTeam(event.getEntity().getUniqueId()).map(BingoTeam::getName).orElse(IChatBaseComponent.b((String)"Spectator").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)"] ")).b((IChatBaseComponent)IChatBaseComponent.b((String)event.getEntity().getDisplayName()).a(EnumChatFormat.a((char)BingoTeam.getTeam(event.getEntity().getUniqueId()).map(BingoTeam::getColor).orElse(ChatColor.GRAY).getChar()))).a(EnumChatFormat.h));
            IChatMutableComponent mutableComponent = (IChatMutableComponent)translatableContents.d()[0];
            IChatMutableComponent finalMessage = (translatableContents.d().length == 1 ? IChatBaseComponent.a((String)translatableContents.b(), (Object[])new Object[]{IChatBaseComponent.a((Message)playerName.b((IChatBaseComponent)mutableComponent))}) : IChatBaseComponent.a((String)translatableContents.b(), (Object[])Stream.concat(Stream.of(playerName), Arrays.stream(Arrays.copyOfRange(translatableContents.d(), 1, translatableContents.d().length))).toList().toArray())).a(EnumChatFormat.h);
            server.getHandle().broadcastMessage(new IChatBaseComponent[]{prefix.b((IChatBaseComponent)finalMessage)});
        } else {
            String finalMessage = Prefix.SERVER + event.getDeathMessage().replace(event.getEntity().getName(), String.valueOf(ChatColor.GRAY) + "[" + BingoTeam.getTeam(event.getEntity().getUniqueId()).map(BingoTeam::getNameAsString).orElse(String.valueOf(ChatColor.GRAY) + "Spectator") + String.valueOf(ChatColor.GRAY) + "] " + event.getEntity().getName() + String.valueOf(ChatColor.GRAY));
            Bukkit.broadcastMessage((String)finalMessage);
        }
        event.setKeepInventory(((Boolean)BingoSetting.getSetting(KeepInventorySetting.class).getValue()).booleanValue());
    }

    @EventHandler
    public void onFood(FoodLevelChangeEvent event) {
        if (!((Boolean)BingoSetting.getSetting(SaturationSetting.class).getValue()).booleanValue()) {
            event.setFoodLevel(20);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().startsWith("/teammsg")) {
            event.setMessage("/teamchat" + event.getMessage().substring("/teammsg".length()));
        }
    }

    @EventHandler
    public void onInv(InventoryClickEvent event) {
        if (GameState.currentGameState.ordinal() >= GameState.INGAME.ordinal()) {
            return;
        }
        if (event.getSlot() < 0) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        ItemStack current = null;
        if (event.getCurrentItem() != null) {
            current = event.getCurrentItem();
        }
        if (event.getHotbarButton() != -1) {
            current = event.getClickedInventory().getItem(event.getHotbarButton());
        }
        if (current == null) {
            return;
        }
        ItemConfiguration itemConfiguration = new ItemConfiguration(current);
        if (!itemConfiguration.hasData("id")) {
            return;
        }
        String id1 = (String)new ItemConfiguration(BingoUtils.settingItem.apply((Player)event.getWhoClicked())).getData("id");
        String id2 = (String)new ItemConfiguration(BingoUtils.startItem.apply((Player)event.getWhoClicked())).getData("id");
        String id3 = (String)new ItemConfiguration(BingoUtils.teamSelectItem((Player)event.getWhoClicked())).getData("id");
        if (((String)itemConfiguration.getData("id")).equals(id1) || ((String)itemConfiguration.getData("id")).equals(id2) || ((String)itemConfiguration.getData("id")).equals(id3)) {
            event.setCancelled(true);
        }
    }
}

