/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.ResourcepackCommand;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.PlayerSessionManager;
import de.eisi05.bingo.manager.ScoreboardManager;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.world.WorldManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;

public class PlayerJoinListener
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        event.setJoinMessage(String.valueOf(ChatColor.GREEN) + "\u00bb " + String.valueOf(ChatColor.GRAY) + event.getPlayer().getName());
        event.getPlayer().setPlayerListHeader(Main.bingoPrefix);
        ResourcepackCommand.resourcepack.accept(event.getPlayer());
        if (GameState.currentGameState.ordinal() >= GameState.TEAM_SELECT.ordinal()) {
            event.getPlayer().setScoreboard(ScoreboardManager.createScoreboard());
        }
        if (GameState.currentGameState.ordinal() >= GameState.STARTING.ordinal()) {
            ScoreboardManager.updateScoreboard(event.getPlayer());
            BingoTeam.getTeam(event.getPlayer().getUniqueId()).ifPresentOrElse(team -> {
                event.getPlayer().setGameMode(GameMode.SURVIVAL);
                team.addPlayer((HumanEntity)event.getPlayer());
                PlayerSessionManager.restoreInventory(event.getPlayer());
                PlayerSessionManager.restoreLocation(event.getPlayer());
            }, () -> {
                event.getPlayer().setGameMode(GameMode.SPECTATOR);
                BingoTeam.addPlayerToSpectator((HumanEntity)event.getPlayer());
            });
            Objective objective = event.getPlayer().getScoreboard().getObjective("objectCount");
            if (objective == null) {
                objective = event.getPlayer().getScoreboard().registerNewObjective("objectCount", Criteria.DUMMY, "Object Count");
                objective.setDisplaySlot(DisplaySlot.PLAYER_LIST);
            }
            for (Player player : Bukkit.getOnlinePlayers()) {
                Objective objective1 = player.getScoreboard().getObjective("objectCount");
                objective.getScore(event.getPlayer().getName()).setScore(objective1.getScore(event.getPlayer().getName()).getScore());
            }
        } else {
            event.getPlayer().teleport(WorldManager.overworld.getSpawnLocation().add(0.0, 1.5, 0.0));
            event.getPlayer().getInventory().clear();
        }
        if (GameState.currentGameState.ordinal() >= GameState.INGAME.ordinal()) {
            event.getPlayer().addAttachment(Main.plugin, "bingo", true);
        } else {
            event.getPlayer().addAttachment(Main.plugin, "bingo", false);
        }
        event.getPlayer().recalculatePermissions();
        event.getPlayer().updateCommands();
        if (GameState.currentGameState == GameState.LOBBY && event.getPlayer().isOp()) {
            event.getPlayer().getInventory().setItem(4, BingoUtils.settingItem.apply(event.getPlayer()));
        }
        if (GameState.currentGameState == GameState.TEAM_SELECT) {
            event.getPlayer().getInventory().setItem(8, BingoUtils.teamSelectItem(event.getPlayer()));
            if (event.getPlayer().isOp()) {
                event.getPlayer().getInventory().setItem(4, BingoUtils.startItem.apply(event.getPlayer()));
            }
        }
    }
}

