/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.manager;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlacementManager {
    public static List<BingoTeam> getFirstPlace() {
        int minMissing = BingoTeam.getSortedTeams().stream().mapToInt(team -> team.getMissingBingoItems().size()).min().orElse(Integer.MAX_VALUE);
        return BingoTeam.getSortedTeams().stream().filter(team -> team.getMissingBingoItems().size() == minMissing).toList();
    }

    public static IChatMutableComponent getPlace(BingoTeam team, @NotNull Player player) {
        TreeMap<Integer, List<BingoTeam>> map = PlacementManager.getMap();
        int index = map.entrySet().stream().filter(integerListEntry -> ((List)integerListEntry.getValue()).contains(team)).map(Map.Entry::getKey).findFirst().orElse(-1);
        if (index == -1) {
            return IChatBaseComponent.b((String)"?");
        }
        int place = (map.containsKey(index) ? map.headMap(index).size() : -1) + 1;
        String placeString = String.valueOf(place);
        return Translation.translate(player, "game.placement." + placeString, new Object[0]);
    }

    private static TreeMap<Integer, List<BingoTeam>> getMap() {
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (BingoTeam team : BingoTeam.getSortedTeams()) {
            List current = map.getOrDefault(team.getMissingBingoItems().size(), new ArrayList());
            current.add(team);
            map.put(team.getMissingBingoItems().size(), current);
        }
        TreeMap<Integer, List<BingoTeam>> tree = new TreeMap<Integer, List<BingoTeam>>(Comparator.comparingInt(value -> value));
        tree.putAll(map);
        return tree;
    }
}

