/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils;

import de.eisi05.bingo.utils.lang.Translation;
import java.io.Serializable;
import java.util.Arrays;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public enum BingoDifficulty implements Serializable
{
    EASY(ChatColor.GREEN),
    NORMAL(ChatColor.YELLOW),
    HARD(ChatColor.RED),
    DISABLED(ChatColor.DARK_RED);

    private final ChatColor color;

    private BingoDifficulty(ChatColor color) {
        this.color = color;
    }

    public static BingoDifficulty[] getAll() {
        return Arrays.stream(BingoDifficulty.values()).filter(bingoDifficulty -> bingoDifficulty != DISABLED).toList().toArray(new BingoDifficulty[0]);
    }

    public ChatColor getColor() {
        return this.color;
    }

    public IChatMutableComponent getName(@NotNull Player player) {
        return Translation.translate(player, "difficulty." + this.name().toLowerCase(), new Object[0]).a(style -> style.a(EnumChatFormat.a((char)this.color.getChar())).b(Boolean.valueOf(false)));
    }

    public BingoDifficulty next(boolean includeDisabled) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NORMAL;
            case 1 -> HARD;
            case 2 -> {
                if (includeDisabled) {
                    yield DISABLED;
                }
                yield EASY;
            }
            case 3 -> includeDisabled ? EASY : DISABLED;
        };
    }

    public BingoDifficulty prev(boolean includeDisabled) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (includeDisabled) {
                    yield DISABLED;
                }
                yield HARD;
            }
            case 1 -> EASY;
            case 2 -> NORMAL;
            case 3 -> includeDisabled ? HARD : DISABLED;
        };
    }
}

