/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.builder;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.numbers.BlankFormat;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboard;
import org.bukkit.entity.Player;

public class NMSScoreboardBuilder {
    private final Scoreboard scoreboard;

    public NMSScoreboardBuilder(IChatBaseComponent displayName, DisplaySlot displaySlot, IScoreboardCriteria criteria) {
        Scoreboard scoreboard = ((CraftScoreboard)Bukkit.getScoreboardManager().getNewScoreboard()).getHandle();
        ScoreboardObjective objective = scoreboard.a("abc", criteria, displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay.a, true, null);
        objective.b((NumberFormat)BlankFormat.a);
        if (displaySlot != null) {
            scoreboard.a(displaySlot, objective);
        }
        this.scoreboard = scoreboard;
    }

    public NMSScoreboardBuilder(Player player) {
        this.scoreboard = ((CraftScoreboard)player.getScoreboard()).getHandle();
    }

    public static void updateTitle(org.bukkit.scoreboard.Scoreboard scoreboard, String title) {
        scoreboard.getObjective("abc").setDisplayName(title);
    }

    public NMSScoreboardBuilder setDisplaySlot(DisplaySlot displaySlot) {
        this.scoreboard.a(displaySlot, this.scoreboard.a("abc"));
        return this;
    }

    public NMSScoreboardBuilder addScore(ScoreboardEntry entry, IChatBaseComponent prefix, IChatBaseComponent suffix) {
        if (this.scoreboard.e(entry.entry) == null) {
            ScoreboardTeam t = this.scoreboard.c(entry.name());
            t.b(prefix);
            t.c(suffix);
            this.scoreboard.a(entry.entry, t);
        }
        ScoreAccess access = this.scoreboard.c(ScoreHolder.c((String)entry.entry), this.scoreboard.a("abc"));
        access.a(entry.ordinal());
        access.f();
        return this;
    }

    public void updateScore(ScoreboardEntry entry, IChatBaseComponent prefix, IChatBaseComponent suffix) {
        try {
            ScoreboardTeam team = this.scoreboard.e(entry.entry);
            team.b(prefix);
            team.c(suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove() {
        for (ScoreboardObjective objective : this.scoreboard.b()) {
            this.scoreboard.j(objective);
        }
    }

    public void updateScoreAll(ScoreboardEntry entry, IChatBaseComponent prefix, IChatBaseComponent suffix) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            new NMSScoreboardBuilder(player).updateScore(entry, prefix, suffix);
        }
    }

    public NMSScoreboardBuilder addTeam(String name, ScoreboardEntry entry, IChatBaseComponent prefix, IChatBaseComponent suffix, EnumChatFormat color) {
        return this.addTeam(name, entry.entry, prefix, suffix, color);
    }

    public NMSScoreboardBuilder addTeam(String name, String entry, IChatBaseComponent prefix, IChatBaseComponent suffix, EnumChatFormat color) {
        ScoreboardTeam team = this.scoreboard.c(name);
        this.scoreboard.a(entry, team);
        team.b(prefix);
        team.c(suffix);
        team.a(color);
        team.b(true);
        return this;
    }

    public NMSScoreboardBuilder addPlayerToTeam(OfflinePlayer player, String name) {
        if (!this.scoreboard.b(name).h().contains(player.getName())) {
            this.scoreboard.a(player.getName(), this.scoreboard.b(name));
        }
        return this;
    }

    public NMSScoreboardBuilder removePlayerFromTeam(OfflinePlayer player, String name) {
        this.scoreboard.b(player.getName(), this.scoreboard.b(name));
        return this;
    }

    public NMSScoreboardBuilder addPlayerToTeamByEntry(OfflinePlayer player, String entry) {
        this.scoreboard.a(player.getName(), this.scoreboard.e(entry));
        return this;
    }

    public CraftScoreboard build() {
        try {
            Constructor constructor = CraftScoreboard.class.getDeclaredConstructor(Scoreboard.class);
            constructor.setAccessible(true);
            return (CraftScoreboard)constructor.newInstance(this.scoreboard);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ScoreboardEntry {
        _1("\u00a70"),
        _2("\u00a71"),
        _3("\u00a72"),
        _4("\u00a73"),
        _5("\u00a74"),
        _6("\u00a75"),
        _7("\u00a76"),
        _8("\u00a77"),
        _9("\u00a78"),
        _10("\u00a79"),
        _11("\u00a7a"),
        _12("\u00a7b"),
        _13("\u00a7c"),
        _14("\u00a7d"),
        _15("\u00a7e");

        public final String entry;

        private ScoreboardEntry(String entry) {
            this.entry = entry;
        }
    }
}

