/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.eisutils.config;

import java.io.File;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    protected final File file;
    protected final MyConfig config;

    public Configuration(File parent, String child) {
        this.file = new File(parent, child);
        this.config = new MyConfig(YamlConfiguration.loadConfiguration((File)this.file));
    }

    public Configuration(File file) {
        this.file = file;
        this.config = new MyConfig(YamlConfiguration.loadConfiguration((File)file));
    }

    public MyConfig getConfig() {
        return this.config;
    }

    public File getFile() {
        return this.file;
    }

    public class MyConfig {
        private YamlConfiguration config;

        public MyConfig(YamlConfiguration config) {
            this.config = config;
        }

        public MyConfig set(String path, Object value) {
            this.load();
            this.config.set(path, value);
            this.save();
            return this;
        }

        public Object get(String path) {
            this.load();
            return this.config.get(path);
        }

        public boolean isEmpty() {
            this.load();
            return this.config.getKeys(false).isEmpty();
        }

        public boolean contains(String path) {
            this.load();
            return this.config.contains(path);
        }

        public YamlConfiguration getConfig() {
            this.load();
            return this.config;
        }

        public void save() {
            try {
                this.config.save(Configuration.this.file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void load() {
            this.config = YamlConfiguration.loadConfiguration((File)Configuration.this.file);
        }
    }
}

