/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.utils.lang;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class LocalizationManager {
    private static final String defaultLang = "en_us";
    private static final Map<String, Map<String, String>> languages = new HashMap<String, Map<String, String>>();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadLanguages(@NotNull JavaPlugin plugin) {
        File[] files;
        languages.clear();
        File langFolder = new File(plugin.getDataFolder(), "lang");
        if (!new File(langFolder, "en_us.json").exists()) {
            plugin.saveResource("lang/en_us.json", false);
        }
        if ((files = langFolder.listFiles()) == null) {
            return;
        }
        for (File jsonFile : files) {
            String langCode = jsonFile.getName().substring(0, jsonFile.getName().length() - 5);
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
                Map map = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, String>>(){}.getType());
                languages.put(langCode, map);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String get(Player player, String key, Object ... replacements) {
        String locale = defaultLang;
        if (player != null && player.getLocale() != null) {
            locale = player.getLocale().toLowerCase(Locale.ROOT);
        }
        return LocalizationManager.get(locale, key, replacements);
    }

    public static String get(String lang, String key, Object ... replacements) {
        Map<String, String> map = languages.getOrDefault(lang, languages.get(defaultLang));
        if (map == null) {
            return key;
        }
        String message = map.getOrDefault(key, key);
        try {
            message = String.format(message, replacements);
        }
        catch (IllegalFormatException illegalFormatException) {
            // empty catch block
        }
        return message;
    }
}

