/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.bingo.settings;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.settings.AllowEnchantmentsSetting;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.manager.SettingsManager;
import de.eisi05.bingo.utils.BingoDifficulty;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import de.eisi05.bingo.utils.eisutils.inventory.ScrollInventoryHolder;
import de.eisi05.bingo.utils.lang.Translation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.apache.commons.lang3.tuple.Triple;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.ServerOperator;
import org.jetbrains.annotations.NotNull;

public final class ManageObjectsSetting
extends BingoSetting<Void> {
    ManageObjectsSetting() {
    }

    private static InventoryBuilder selectType() {
        int[] slots = new int[]{12, 14, 20, 22, 24};
        Class<BingoObject<?>>[] classes = BingoObject.getClasses();
        InventoryBuilder builder = new InventoryBuilder(36, "Settings >> Select Type");
        for (int i = 0; i < slots.length; ++i) {
            Class<BingoObject<?>> current = classes[i];
            builder.setItem(slots[i], new ItemBuilder(BingoObject.getIcon(current)).setName((IChatBaseComponent)BingoObject.getName(current).a(EnumChatFormat.j)).setLore(new IChatBaseComponent[]{IChatBaseComponent.b((String)"> ").a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)(BingoObject.getBingoObjects(ManageObjectsSetting.cast(current)).size() + " Entries")).a(EnumChatFormat.h))}).setClickHandler("select-type-" + current.getSimpleName(), event -> {
                ScrollInventory inventory = ManageObjectsSetting.getInventory(ManageObjectsSetting.cast(current));
                inventory.getInventory(1).openAsNMS(event.getWhoClicked(), inventory.getTitle());
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
            }).build());
        }
        return builder.setArrowLeft((IChatBaseComponent)IChatBaseComponent.b((String)"Previous"), "manage-objects-previous", event -> SettingsManager.getSettingsInventory().open(event.getWhoClicked())).normal();
    }

    private static <T> Class<T> cast(Class<?> c) {
        return c;
    }

    public static <T> ScrollInventory getInventory(Class<? extends BingoObject<T>> clazz) {
        ScrollInventory scrollInventory = new ScrollInventory(new ManageObjectsHolder(clazz), Translation.SETTINGS.f().b((IChatBaseComponent)IChatBaseComponent.b((String)" >> ").b((IChatBaseComponent)BingoObject.getName(clazz))), new ArrayList<ItemStack>(), true, new ScrollInventory.Hotbar(1, new ItemBuilder(Material.BOOK).setName((IChatBaseComponent)IChatBaseComponent.b((String)"Color Explanation").a(EnumChatFormat.h)).setLore(new IChatBaseComponent[]{IChatBaseComponent.b((String)"Overworld").a(EnumChatFormat.p), IChatBaseComponent.b((String)"Nether").a(EnumChatFormat.n), IChatBaseComponent.b((String)"The End").a(EnumChatFormat.o)}).setClickHandler("cancel", event -> event.setCancelled(true)).build()), clazz.equals(BingoObject.BingoItem.class) ? new ScrollInventory.Hotbar(3, BingoSetting.getSetting(AllowEnchantmentsSetting.class).getIcon().build()) : null);
        scrollInventory.setItems(BingoObject.getBingoObjects(clazz).stream().map(bingoObject -> {
            List<IChatBaseComponent> lore = ManageObjectsSetting.getLore(bingoObject);
            ManageObjectsSetting.modifyLore(bingoObject, lore);
            return new ItemBuilder(bingoObject.asDisplayIcon()).setLore(lore.toArray(new IChatBaseComponent[0])).setScrollClickHandler("manage-objects-scroll-" + String.valueOf(bingoObject), (event, scrollInventory1) -> {
                bingoObject.setDifficulty(event.isLeftClick() ? bingoObject.getDifficulty().next(true) : bingoObject.getDifficulty().prev(true));
                List<IChatBaseComponent> modifiedLore = ManageObjectsSetting.getLore(bingoObject);
                ManageObjectsSetting.modifyLore(bingoObject, modifiedLore);
                ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
                ItemStack before = event.getCurrentItem().clone();
                ItemStack item = event.getCurrentItem();
                item.setItemMeta(ItemBuilder.setLore(item, modifiedLore).getItemMeta());
                scrollInventory1.replaceSimple(before, item);
                ScrollInventoryHolder holder = (ScrollInventoryHolder)event.getClickedInventory().getHolder();
                Bukkit.getOnlinePlayers().stream().filter(player -> !player.equals((Object)event.getWhoClicked())).filter(ServerOperator::isOp).filter(player -> {
                    ScrollInventory patt2$temp;
                    Object holder1;
                    Inventory topInventory = player.getOpenInventory().getTopInventory();
                    if (topInventory == null) {
                        return false;
                    }
                    InventoryHolder inventoryHolder = topInventory.getHolder();
                    if (!(inventoryHolder instanceof ScrollInventoryHolder)) return false;
                    ScrollInventoryHolder $b$0 = (ScrollInventoryHolder)inventoryHolder;
                    try {
                        Object patt1$temp;
                        holder1 = patt1$temp = $b$0.holder();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    ScrollInventory inventory = patt2$temp = $b$0.scrollInventory();
                    if (inventory.getPage() != holder.scrollInventory().getPage()) return false;
                    if (!(holder1 instanceof ManageObjectsHolder)) return false;
                    if (!((ManageObjectsHolder)holder1).clazz.equals(clazz)) return false;
                    return true;
                }).forEach(player -> player.getOpenInventory().setItem(event.getSlot(), item));
            }, scrollInventory).build();
        }).toList());
        return scrollInventory.setArrowBackEvent("manage-objects-back", event -> ManageObjectsSetting.selectType().openAsNMS(event.getWhoClicked(), (IChatBaseComponent)Translation.SETTINGS.f().b((IChatBaseComponent)IChatBaseComponent.b((String)" >> ").b((IChatBaseComponent)IChatBaseComponent.b((String)"Select Type")))));
    }

    private static List<IChatBaseComponent> getLore(BingoObject<?> bingoObject) {
        return new ArrayList<IChatMutableComponent>(Arrays.stream(BingoDifficulty.values()).map(bingoDifficulty -> bingoDifficulty.getName().a(style -> style.a(bingoObject.getDifficulty() == bingoDifficulty ? EnumChatFormat.a((char)bingoDifficulty.getColor().getChar()) : EnumChatFormat.h).a(Boolean.valueOf(bingoDifficulty == BingoDifficulty.DISABLED && bingoObject.getDifficulty() == bingoDifficulty)))).toList());
    }

    private static void modifyLore(BingoObject<?> bingoObject, List<IChatBaseComponent> lore) {
        if (bingoObject.getClass().equals(BingoObject.BingoAdvancement.class)) {
            lore.addFirst((IChatBaseComponent)IChatBaseComponent.i());
            lore.addAll(0, ItemBuilder.getLore(bingoObject.asDisplayIcon()));
            Object obj = bingoObject.getObject();
            if (!(obj instanceof Advancement)) {
                return;
            }
            Advancement advancement = (Advancement)obj;
            if (advancement.getKey().getKey().equals("adventure/totem_of_undying")) {
                lore.addAll(2, List.of(IChatBaseComponent.b((String)"When this object is selected,").a(style -> style.a(EnumChatFormat.m).b(Boolean.valueOf(false))), IChatBaseComponent.b((String)"Damage will be enabled automatically!").a(style -> style.a(EnumChatFormat.m).b(Boolean.valueOf(false)))));
                lore.add(4, (IChatBaseComponent)IChatBaseComponent.i());
            }
        }
        if (bingoObject.getObject().equals(EntityType.PLAYER)) {
            lore.addFirst((IChatBaseComponent)IChatBaseComponent.i());
            lore.addAll(0, List.of(IChatBaseComponent.b((String)"When this object is selected,").a(style -> style.a(EnumChatFormat.m).b(Boolean.valueOf(false))), IChatBaseComponent.b((String)"PVP will be enabled automatically!").a(style -> style.a(EnumChatFormat.m).b(Boolean.valueOf(false)))));
        }
    }

    @Override
    public Void getDefaultValue() {
        return null;
    }

    @Override
    public ItemBuilder getIcon() {
        return new ItemBuilder(Material.CRAFTING_TABLE).setName((IChatBaseComponent)IChatBaseComponent.b((String)"Manage Objects").a(style -> style.a(EnumChatFormat.o).b(Boolean.valueOf(false)))).setLore(this.getDescription(false)).setClickHandler("manage-objects", event -> {
            ManageObjectsSetting.selectType().openAsNMS(event.getWhoClicked(), (IChatBaseComponent)Translation.SETTINGS.f().b((IChatBaseComponent)IChatBaseComponent.b((String)" >> ").b((IChatBaseComponent)IChatBaseComponent.b((String)"Select Type"))));
            ((Player)event.getWhoClicked()).playSound((Entity)event.getWhoClicked(), Sound.BLOCK_NOTE_BLOCK_HAT, 100.0f, 1.0f);
        });
    }

    @Override
    public IChatBaseComponent getSettingsText() {
        return null;
    }

    @Override
    public int getSlot() {
        return 49;
    }

    @Override
    public List<Triple<String, String, Boolean>> getDescriptionKeys() {
        return List.of(Triple.of((Object)"options.manageObjects.description.1", (Object)"Manage the Difficulty of the Objects", (Object)false));
    }

    public record ManageObjectsHolder<T>(Class<? extends BingoObject<T>> clazz) implements InventoryHolder
    {
        @NotNull
        public Inventory getInventory() {
            return null;
        }
    }
}

