/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.game;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.ScoreboardManager;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GameActionBar {
    private static BukkitTask task;
    private static int counter;
    private static final String[] DOTS;

    public static void enable() {
        task = new BukkitRunnable(){

            public void run() {
                GameState state = GameState.currentGameState;
                for (Player player : Bukkit.getOnlinePlayers()) {
                    BaseComponent message = switch (state) {
                        default -> throw new MatchException(null, null);
                        case GameState.LOBBY -> GameActionBar.lobbyMessage(player);
                        case GameState.TEAM_SELECT -> GameActionBar.teamSelectMessage(player);
                        case GameState.STARTING -> TextComponent.fromLegacy((String)Main.bingoPrefix);
                        case GameState.INGAME, GameState.RESTART -> {
                            task.cancel();
                            yield TextComponent.fromLegacy((String)"");
                        }
                        case GameState.FINISH -> GameActionBar.finishMessage();
                    };
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, message);
                }
                if (++counter >= 260) {
                    counter = 0;
                }
            }
        }.runTaskTimerAsynchronously(Main.plugin, 0L, 1L);
    }

    public static void disable() {
        if (task != null && (Bukkit.getScheduler().isQueued(task.getTaskId()) || Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId()))) {
            task.cancel();
        }
    }

    private static BaseComponent lobbyMessage(Player player) {
        if (counter < 160) {
            TextComponent msg;
            if (player.isOp()) {
                msg = new TextComponent("You are an operator");
                msg.setColor(net.md_5.bungee.api.ChatColor.GRAY);
            } else {
                msg = new TextComponent("Waiting for operator");
                msg.setColor(net.md_5.bungee.api.ChatColor.GRAY);
            }
            return GameActionBar.animate((BaseComponent)msg);
        }
        return TextComponent.fromLegacy((String)ScoreboardManager.getAuthor());
    }

    private static BaseComponent teamSelectMessage(Player player) {
        TextComponent base = new TextComponent(player.isOp() ? "Waiting for you to start the game" : "Waiting for operator to start the game");
        base.setColor(net.md_5.bungee.api.ChatColor.GRAY);
        BaseComponent msg = GameActionBar.animate((BaseComponent)base);
        return counter < 160 ? msg : (BaseComponent)BingoTeam.getTeam(player.getUniqueId()).map(team -> {
            TextComponent teamMsg = new TextComponent("You are in team " + CraftChatMessage.fromComponent((IChatBaseComponent)team.getName()));
            teamMsg.setColor(net.md_5.bungee.api.ChatColor.GRAY);
            return teamMsg;
        }).orElseGet(() -> {
            TextComponent teamMsg = new TextComponent("Choose your team");
            teamMsg.setColor(net.md_5.bungee.api.ChatColor.GRAY);
            return teamMsg;
        });
    }

    private static BaseComponent finishMessage() {
        if (GameState.restartTime == -1L) {
            TextComponent msg = new TextComponent("Game over!");
            msg.setColor(net.md_5.bungee.api.ChatColor.RED);
            return msg;
        }
        long seconds = (GameState.restartTime - System.currentTimeMillis()) / 1000L;
        if (seconds <= 0L) {
            new BukkitRunnable(){

                public void run() {
                    GameState.setGameState(GameState.RESTART);
                }
            }.runTask(Main.plugin);
            task.cancel();
        }
        TextComponent comp = new TextComponent("Game over! ");
        TextComponent timer = new TextComponent(String.valueOf(ChatColor.RED) + "Server restarting in " + String.valueOf(ChatColor.GRAY) + seconds + String.valueOf(ChatColor.RED) + " seconds!");
        comp.addExtra((BaseComponent)timer);
        comp.setColor(net.md_5.bungee.api.ChatColor.RED);
        return comp;
    }

    private static BaseComponent animate(BaseComponent base) {
        int step;
        int phase = counter % 160;
        int n = phase < 20 || phase >= 80 && phase < 100 ? 1 : (phase < 40 || phase >= 100 && phase < 120 ? 2 : (phase < 60 || phase >= 120 && phase < 140 ? 3 : (step = phase < 80 || phase >= 140 && phase < 160 ? 4 : -1)));
        if (step == -1) {
            return null;
        }
        TextComponent msg = new TextComponent();
        msg.addExtra(DOTS[step - 1]);
        msg.addExtra(" ");
        msg.addExtra(base);
        msg.addExtra(" ");
        msg.addExtra(DOTS[(step + 1) % DOTS.length]);
        return msg;
    }

    private static String makeDots(int step) {
        return switch (step) {
            case 1 -> String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf\u25cf" + String.valueOf(ChatColor.RESET);
            case 2, 4 -> String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.RESET);
            case 3 -> String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf\u25cf" + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.RESET);
            default -> "";
        };
    }

    static {
        counter = 0;
        DOTS = new String[]{GameActionBar.makeDots(1), GameActionBar.makeDots(2), GameActionBar.makeDots(3), GameActionBar.makeDots(4)};
    }
}

