/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.listener.CollectListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructurePiece;
import org.bukkit.util.BoundingBox;

public class CollectStructureListener
implements CollectListener<Structure> {
    private static final Map<BingoTeam, Set<Structure>> collectedStructures = new HashMap<BingoTeam, Set<Structure>>();

    public CollectStructureListener() {
        CollectListener.CollectScheduler.registerTask(() -> {
            for (Map.Entry<UUID, BingoTeam> entry : CollectListener.CollectScheduler.getPlayerTeamMap().entrySet()) {
                UUID uuid = entry.getKey();
                BingoTeam team = entry.getValue();
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null || !player.isOnline()) continue;
                collectedStructures.putIfAbsent(team, new HashSet());
                Set<Structure> teamCollected = collectedStructures.get(team);
                Collection structures = player.getWorld().getStructures(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ());
                if (structures.isEmpty()) continue;
                block1: for (GeneratedStructure generatedStructure : structures) {
                    Structure structure = generatedStructure.getStructure();
                    if (teamCollected.contains(structure)) continue;
                    for (StructurePiece piece : generatedStructure.getPieces()) {
                        BoundingBox box = piece.getBoundingBox().clone().expand(2.0, 2.0, 2.0);
                        if (!box.overlaps(player.getBoundingBox()) && !box.contains(player.getBoundingBox())) continue;
                        this.collect(structure, (OfflinePlayer)player);
                        teamCollected.add(structure);
                        continue block1;
                    }
                }
            }
        });
    }
}

