/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPISpigot;
import dev.jorel.commandapi.CommandAPISpigotConfig;
import dev.jorel.commandapi.InternalSpigotConfig;
import dev.jorel.commandapi.LoadContext;
import dev.jorel.commandapi.MojangMappedVersionHandler;
import dev.jorel.commandapi.exceptions.UnsupportedVersionException;
import dev.jorel.commandapi.nms.SpigotNMS_1_20_R1;
import dev.jorel.commandapi.nms.SpigotNMS_1_20_R2;
import dev.jorel.commandapi.nms.SpigotNMS_1_20_R3;
import dev.jorel.commandapi.nms.SpigotNMS_1_20_R4;
import dev.jorel.commandapi.nms.SpigotNMS_1_21_R1;
import dev.jorel.commandapi.nms.SpigotNMS_1_21_R2;
import dev.jorel.commandapi.nms.SpigotNMS_1_21_R3;
import dev.jorel.commandapi.nms.SpigotNMS_1_21_R4;
import dev.jorel.commandapi.nms.SpigotNMS_1_21_R5;
import dev.jorel.commandapi.nms.SpigotNMS_1_21_R6;
import org.bukkit.Bukkit;

public abstract class CommandAPIVersionHandler {
    static LoadContext getPlatform(CommandAPIConfig<?> config) {
        if (!(config instanceof CommandAPISpigotConfig)) {
            throw new IllegalArgumentException("CommandAPISpigot was loaded with non-Spigot config!");
        }
        CommandAPISpigotConfig spigotConfig = (CommandAPISpigotConfig)config;
        InternalSpigotConfig internalSpigotConfig = new InternalSpigotConfig(spigotConfig);
        try {
            CommandAPISpigot platform;
            String version;
            switch (version = Bukkit.getBukkitVersion().split("-")[0]) {
                case "1.20": 
                case "1.20.1": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_20_R1(internalSpigotConfig);
                    break;
                }
                case "1.20.2": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_20_R2(internalSpigotConfig);
                    break;
                }
                case "1.20.3": 
                case "1.20.4": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_20_R3(internalSpigotConfig);
                    break;
                }
                case "1.20.5": 
                case "1.20.6": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_20_R4(internalSpigotConfig);
                    break;
                }
                case "1.21": 
                case "1.21.1": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_21_R1(internalSpigotConfig);
                    break;
                }
                case "1.21.2": 
                case "1.21.3": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_21_R2(internalSpigotConfig);
                    break;
                }
                case "1.21.4": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_21_R3(internalSpigotConfig);
                    break;
                }
                case "1.21.5": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_21_R4(internalSpigotConfig);
                    break;
                }
                case "1.21.6": 
                case "1.21.7": 
                case "1.21.8": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_21_R5(internalSpigotConfig);
                    break;
                }
                case "1.21.9": 
                case "1.21.10": {
                    CommandAPISpigot commandAPISpigot = new SpigotNMS_1_21_R6(internalSpigotConfig);
                    break;
                }
                default: {
                    CommandAPISpigot commandAPISpigot = platform = null;
                }
            }
            if (platform != null) {
                return new LoadContext(platform);
            }
            if (internalSpigotConfig.fallbackToLatestNMS()) {
                return new LoadContext(new SpigotNMS_1_21_R6(internalSpigotConfig), () -> {
                    CommandAPI.logWarning("Loading the CommandAPI with the latest and potentially incompatible NMS implementation.");
                    CommandAPI.logWarning("While you may find success with this, further updates might be necessary to fully support the version you are using.");
                });
            }
            throw new UnsupportedVersionException(version);
        }
        catch (Throwable error) {
            throw new IllegalStateException("The CommandAPI's NMS hook failed to load! This version of the CommandAPI is " + (MojangMappedVersionHandler.isMojangMapped() ? "Mojang" : "Spigot") + "-mapped. Have you checked that you are using a CommandAPI version that matches the mappings that your plugin is using?", error);
        }
    }
}

