/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo;

import de.eisi05.bingo.bingo.BingoObjectsHandler;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.commands.ResourcepackCommand;
import de.eisi05.bingo.game.GameActionBar;
import de.eisi05.bingo.listener.GameListener;
import de.eisi05.bingo.listener.PlayerChatListener;
import de.eisi05.bingo.listener.PlayerJoinListener;
import de.eisi05.bingo.listener.PlayerLeaveListener;
import de.eisi05.bingo.listener.ResourcepackListener;
import de.eisi05.bingo.listener.ServerReloadListener;
import de.eisi05.bingo.listener.WorldCreateListener;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.RestartFile;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.builder.ItemBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import de.eisi05.bingo.utils.eisutils.inventory.InventorySaver;
import de.eisi05.bingo.utils.eisutils.listeners.InventoryClickListener;
import de.eisi05.bingo.world.WorldManager;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.advancement.CraftAdvancementDisplay;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.spigotmc.SpigotConfig;

public final class Main
extends JavaPlugin {
    public static Plugin plugin;
    public static String bingoPrefix;
    public static IChatMutableComponent bingoPrefixComponent;

    public void onLoad() {
        plugin = this;
        CommandAPI.onLoad(new CommandAPIBukkitConfig(this).silentLogs(true));
    }

    public void onEnable() {
        if (new File(Bukkit.getWorldContainer(), "world").exists()) {
            WorldManager.deleteWorld(new File(Bukkit.getWorldContainer(), "world"));
        }
        BingoUtils.load();
        bingoPrefix = BingoUtils.generateGradientString("Bingo!", "#00b0b6", "#00f06b");
        bingoPrefixComponent = BingoUtils.generateGradientComponent("Bingo!", "#00b0b6", "#00f06b");
        Prefix.SERVER = String.valueOf(ChatColor.DARK_GRAY) + "[" + bingoPrefix + String.valueOf(ChatColor.DARK_GRAY) + "] ";
        boolean restart = false;
        if (!this.getServer().getAllowNether()) {
            File propertiesFile = new File("server.properties");
            Properties properties = new Properties();
            try (FileInputStream in = new FileInputStream(propertiesFile);){
                properties.load(in);
                properties.setProperty("allow-nether", "true");
                try (FileOutputStream out = new FileOutputStream(propertiesFile);){
                    properties.store(out, null);
                }
                Bukkit.getLogger().info("Nether Enabled");
                restart = true;
            }
            catch (IOException e) {
                Bukkit.getLogger().warning("Nether could not be enabled");
                throw new RuntimeException();
            }
        }
        if (!this.getServer().getAllowEnd()) {
            CraftServer server = (CraftServer)Bukkit.getServer();
            try {
                Field field = server.getClass().getDeclaredField("configuration");
                field.setAccessible(true);
                YamlConfiguration config = (YamlConfiguration)field.get(server);
                config.set("settings.allow-end", (Object)true);
                Method saveMethod = server.getClass().getDeclaredMethod("saveConfig", new Class[0]);
                saveMethod.setAccessible(true);
                saveMethod.invoke((Object)server, new Object[0]);
                Bukkit.getLogger().info("End Enabled");
                restart = true;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                Bukkit.getLogger().warning("End could not be enabled");
                throw new RuntimeException();
            }
        }
        if (restart) {
            RestartFile.create();
            Bukkit.spigot().restart();
            return;
        }
        this.commandRegistration();
        this.listenerRegistration();
        new ScrollInventory((Plugin)this);
        new InventorySaver((Plugin)this);
        this.getLogger().info("Lading Objects...");
        BingoObjectsHandler.loadObjects();
        Bukkit.advancementIterator().forEachRemaining(advancement -> {
            if (advancement.getDisplay() == null) {
                return;
            }
            AdvancementDisplay displayInfo = ((CraftAdvancementDisplay)advancement.getDisplay()).getHandle();
            try {
                Field showToast = displayInfo.getClass().getDeclaredField("h");
                showToast.setAccessible(true);
                showToast.set(displayInfo, false);
                Field announce = displayInfo.getClass().getDeclaredField("i");
                announce.setAccessible(true);
                announce.set(displayInfo, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        GameActionBar.enable();
        SpigotConfig.disablePlayerDataSaving = true;
        SpigotConfig.saveUserCacheOnStopOnly = true;
    }

    public void onDisable() {
        GameActionBar.disable();
        WorldManager.deleteWorlds();
        BingoObjectsHandler.saveObjects();
        HandlerList.unregisterAll((Plugin)this);
    }

    private void commandRegistration() {
        new ResourcepackCommand();
        for (Class<?> command : AbstractCommand.class.getPermittedSubclasses()) {
            try {
                command.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void listenerRegistration() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new PlayerChatListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new GameListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerLeaveListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldCreateListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ServerReloadListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ResourcepackListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ItemBuilder.ItemListener(), (Plugin)this);
    }
}

