/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.commands;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.commands.AbstractCommand;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.utils.BingoUtils;
import de.eisi05.bingo.utils.eisutils.builder.InventoryBuilder;
import de.eisi05.bingo.utils.eisutils.builder.ScrollInventory;
import dev.jorel.commandapi.executors.CommandArguments;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public non-sealed class BingoCommand
extends AbstractCommand
implements InventoryHolder {
    public BingoCommand() {
        super("bingo", "command.bingo.description", "Opens the bingo board");
        this.withPermission("bingo");
        this.withFullDescription("Opens the bingo board");
        this.executesPlayer((Player player, CommandArguments args) -> {
            if (GameState.currentGameState != GameState.INGAME) {
                BingoUtils.sendMessage((HumanEntity)player, (IChatBaseComponent)IChatBaseComponent.a((String)"game.none", (String)"There is no game running!").a(EnumChatFormat.m), true);
                return;
            }
            player.openInventory(this.getBingoInventory(BingoTeam.getTeam(player.getUniqueId()).orElse(null)));
        });
        this.register();
    }

    private Inventory getBingoInventory(@Nullable BingoTeam team) {
        int maxInvSize;
        int selectedSize = BingoObject.getSelectedObjects().size();
        if (selectedSize < (maxInvSize = 54)) {
            InventoryType type = InventoryType.CHEST;
            switch (selectedSize) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    type = InventoryType.HOPPER;
                    break;
                }
                case 9: {
                    type = InventoryType.DROPPER;
                }
            }
            int invSize = type == InventoryType.CHEST ? (selectedSize + 8) / 9 * 9 : selectedSize;
            InventoryBuilder builder = type == InventoryType.CHEST ? new InventoryBuilder((InventoryHolder)this, invSize, "Bingo") : new InventoryBuilder((InventoryHolder)this, type, "Bingo");
            builder.addItems(team == null ? BingoTeam.getDefaultBingoItems() : team.getBingoItems());
            return builder.normal().build();
        }
        return new ScrollInventory(this, IChatBaseComponent.b((String)"Bingo"), team == null ? BingoTeam.getDefaultBingoItems() : team.getBingoItems(), true, new ScrollInventory.Hotbar[0]).setArrowBackEvent(event -> event.getWhoClicked().closeInventory()).start();
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }
}

