/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.ScoreboardManager;
import de.eisi05.bingo.utils.eisutils.Prefix;
import de.eisi05.bingo.utils.eisutils.toast.AdvancementFrame;
import de.eisi05.bingo.utils.eisutils.toast.ToastNotification;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public interface CollectListener<T>
extends Listener {
    default public void collect(T object, OfflinePlayer offlinePlayer) {
        if (object == null || GameState.currentGameState != GameState.INGAME) {
            return;
        }
        BingoTeam.getTeam(offlinePlayer.getUniqueId()).ifPresent(team -> {
            for (BingoObject<?> missingObj : team.getMissingBingoItems()) {
                BingoObject<?> missing;
                if (!missingObj.getObjectClass().isAssignableFrom(object.getClass()) || !(missing = missingObj).isSimilarObject(object)) continue;
                team.foundBingoItem(missing);
                IChatMutableComponent message = ((IChatMutableComponent)CraftChatMessage.fromStringOrEmpty((String)Prefix.SERVER)).b((IChatBaseComponent)IChatBaseComponent.b((String)offlinePlayer.getName()).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)team.getName().a(EnumChatFormat.a((char)team.getColor().getChar()))).b((IChatBaseComponent)IChatBaseComponent.b((String)") ").a(EnumChatFormat.h)).b((IChatBaseComponent)missing.getFoundVerb().a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)" ")).b((IChatBaseComponent)missing.getName().a(EnumChatFormat.j)).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.i)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team.getMissingBingoItems().size())).a(style -> style.a(EnumChatFormat.m).a(Boolean.valueOf(true)))).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.i)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.i));
                ((CraftServer)Bukkit.getServer()).getHandle().broadcastMessage(new IChatBaseComponent[]{message});
                ToastNotification toast = new ToastNotification(missing.asDisplayIcon(), (IChatBaseComponent)missing.getName().a(EnumChatFormat.j).f(" ").b((IChatBaseComponent)missing.getFoundVerb().a(EnumChatFormat.h)), AdvancementFrame.TASK);
                team.getPlayers().stream().map(Bukkit::getOfflinePlayer).filter(OfflinePlayer::isOnline).map(OfflinePlayer::getPlayer).forEach(player -> {
                    toast.send((Player)player);
                    player.playSound((Entity)player, Sound.ENTITY_PLAYER_LEVELUP, 100.0f, 1.0f);
                    if (player.getOpenInventory().getTopInventory().getHolder() instanceof BingoTeam.BingoTeamInventoryHolder) {
                        player.performCommand("bingo");
                    }
                });
                Bukkit.getOnlinePlayers().forEach(ScoreboardManager::updateScoreboard);
                if (!team.getMissingBingoItems().isEmpty()) break;
                GameState.setGameState(GameState.FINISH);
                break;
            }
        });
    }
}

