/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.listener;

import de.eisi05.bingo.listener.CollectListener;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.generator.structure.GeneratedStructure;
import org.bukkit.generator.structure.Structure;
import org.bukkit.util.BoundingBox;

public class CollectStructureListener
implements CollectListener<Structure> {
    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockY() == event.getTo().getBlockY() && event.getFrom().getBlockZ() == event.getTo().getBlockZ()) {
            return;
        }
        Collection structures = event.getTo().getWorld().getStructures(event.getTo().getChunk().getX(), event.getTo().getChunk().getZ());
        if (structures.isEmpty()) {
            return;
        }
        for (GeneratedStructure generatedStructure : structures) {
            BoundingBox box = generatedStructure.getBoundingBox();
            if (box.getWidthX() < 3.0 || box.getHeight() < 3.0 || box.getWidthZ() < 3.0) {
                box = box.clone().expand(box.getWidthX() < 3.0 ? 3.0 : 0.0, box.getHeight() < 3.0 ? 3.0 : 0.0, box.getWidthZ() < 3.0 ? 3.0 : 0.0);
            }
            if (!box.overlaps(event.getPlayer().getBoundingBox()) && !box.contains(event.getPlayer().getBoundingBox())) continue;
            this.collect(generatedStructure.getStructure(), (OfflinePlayer)event.getPlayer());
        }
    }
}

