/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.manager;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoObject;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.bingo.settings.BingoSetting;
import de.eisi05.bingo.bingo.settings.TimeSetting;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.listener.ResourcepackListener;
import de.eisi05.bingo.manager.PlacementManager;
import de.eisi05.bingo.utils.eisutils.builder.NMSScoreboardBuilder;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardManager {
    public static Scoreboard createScoreboard() {
        NMSScoreboardBuilder builder = new NMSScoreboardBuilder((IChatBaseComponent)IChatBaseComponent.i(), null, IScoreboardCriteria.c);
        builder.addTeam("Spectator", "team0", (IChatBaseComponent)IChatBaseComponent.b((String)"[").b((IChatBaseComponent)IChatBaseComponent.a((String)"game.spectator", (String)"Spectator")).f("] ").a(EnumChatFormat.h), (IChatBaseComponent)IChatBaseComponent.i(), EnumChatFormat.h);
        for (BingoTeam team : BingoTeam.teams) {
            builder.addTeam(team.getNameAsString(), "team" + team.getId(), (IChatBaseComponent)IChatBaseComponent.b((String)"[").a(EnumChatFormat.h).b((IChatBaseComponent)team.getName().a(EnumChatFormat.a((char)team.getColor().getChar())).b((IChatBaseComponent)IChatBaseComponent.b((String)"] ").a(EnumChatFormat.h))), (IChatBaseComponent)IChatBaseComponent.i(), EnumChatFormat.a((char)team.getColor().getChar()));
            team.getPlayers().stream().filter(uuid -> Bukkit.getOfflinePlayer((UUID)uuid) != null).forEach(uuid -> builder.addPlayerToTeam(Bukkit.getOfflinePlayer((UUID)uuid), team.getNameAsString()));
        }
        for (NMSScoreboardBuilder.ScoreboardEntry entry : NMSScoreboardBuilder.ScoreboardEntry.values()) {
            builder.addScore(entry, (IChatBaseComponent)IChatBaseComponent.i(), (IChatBaseComponent)IChatBaseComponent.i());
        }
        return builder.build();
    }

    public static void updateScoreboard(Player player) {
        NMSScoreboardBuilder builder = new NMSScoreboardBuilder(player).setDisplaySlot(DisplaySlot.b);
        List<IChatMutableComponent> firstList = PlacementManager.getFirstPlace().stream().map(BingoTeam::getName).toList();
        IChatMutableComponent first = IChatBaseComponent.i();
        if (firstList.size() > 5) {
            for (i = 0; i < 5; ++i) {
                first = first.b((IChatBaseComponent)firstList.get(i).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)", "));
            }
            first = first.f("...").a(EnumChatFormat.h);
        } else {
            for (i = 0; i < firstList.size(); ++i) {
                first = first.b((IChatBaseComponent)firstList.get(i).a(EnumChatFormat.h));
                if (i == firstList.size() - 1) continue;
                first = first.b((IChatBaseComponent)IChatBaseComponent.b((String)", "));
            }
        }
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._15, (IChatBaseComponent)IChatBaseComponent.a((String)"game.placement.1", (String)"1st").f(": ").a(EnumChatFormat.g), (IChatBaseComponent)first);
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._14, (IChatBaseComponent)IChatBaseComponent.a((String)"game.placement.title", (String)"Placement").f(": ").a(EnumChatFormat.h), (IChatBaseComponent)BingoTeam.getTeam(player.getUniqueId()).map(PlacementManager::getPlace).orElse(IChatBaseComponent.b((String)"?")).a(EnumChatFormat.k));
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._13, (IChatBaseComponent)IChatBaseComponent.i(), (IChatBaseComponent)IChatBaseComponent.i());
        if (BingoTeam.getTeam(player.getUniqueId()).isPresent()) {
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._12, (IChatBaseComponent)IChatBaseComponent.a((String)"game.objects.title", (String)"Objects").f(" ").a(EnumChatFormat.j), (IChatBaseComponent)IChatBaseComponent.b((String)"(").a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)("" + (BingoObject.getSelectedObjects().size() - BingoTeam.getTeam(player.getUniqueId()).map(team -> team.getMissingBingoItems().size()).orElse(BingoObject.getSelectedObjects().size())))).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h)));
            IChatBaseComponent item1 = ScoreboardManager.getItem(player, 0);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._11, (IChatBaseComponent)(item1.equals((Object)IChatBaseComponent.i()) ? IChatBaseComponent.i() : ScoreboardManager.getBingoObjectSymbol(player, 0)), item1);
            IChatBaseComponent item2 = ScoreboardManager.getItem(player, 1);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._10, (IChatBaseComponent)(item2.equals((Object)IChatBaseComponent.i()) ? IChatBaseComponent.i() : ScoreboardManager.getBingoObjectSymbol(player, 1)), item2);
            IChatBaseComponent item3 = ScoreboardManager.getItem(player, 2);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._9, (IChatBaseComponent)(item3.equals((Object)IChatBaseComponent.i()) ? IChatBaseComponent.i() : ScoreboardManager.getBingoObjectSymbol(player, 2)), item3);
            IChatBaseComponent item4 = ScoreboardManager.getItem(player, 3);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._8, (IChatBaseComponent)(item4.equals((Object)IChatBaseComponent.i()) ? IChatBaseComponent.i() : ScoreboardManager.getBingoObjectSymbol(player, 3)), item4);
            IChatBaseComponent item5 = ScoreboardManager.getItem(player, 4);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._7, (IChatBaseComponent)(item5.equals((Object)IChatBaseComponent.i()) ? IChatBaseComponent.i() : ScoreboardManager.getBingoObjectSymbol(player, 4)), item5);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._6, (IChatBaseComponent)IChatBaseComponent.i(), (IChatBaseComponent)IChatBaseComponent.i());
            int more = BingoTeam.getTeam(player.getUniqueId()).map(team -> team.getMissingBingoItems().size() - 5).orElse(0);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._5, (IChatBaseComponent)(more <= 0 ? IChatBaseComponent.i() : IChatBaseComponent.a((String)"game.objects.more", (String)("and " + more + " Objects more"), (Object[])new Object[]{more}).a(EnumChatFormat.i)), (IChatBaseComponent)IChatBaseComponent.i());
        } else {
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._12, (IChatBaseComponent)IChatBaseComponent.a((String)"game.teams.title", (String)"Teams").a(EnumChatFormat.j), (IChatBaseComponent)IChatBaseComponent.b((String)"(").a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoTeam.teams.size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h)));
            BingoTeam team1 = ScoreboardManager.getTeam(0);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._11, (IChatBaseComponent)(team1 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team1 == null ? IChatBaseComponent.i() : team1.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team1.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
            BingoTeam team2 = ScoreboardManager.getTeam(1);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._10, (IChatBaseComponent)(team2 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team2 == null ? IChatBaseComponent.i() : team2.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team2.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
            BingoTeam team3 = ScoreboardManager.getTeam(2);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._9, (IChatBaseComponent)(team3 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team3 == null ? IChatBaseComponent.i() : team3.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team3.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
            BingoTeam team4 = ScoreboardManager.getTeam(3);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._8, (IChatBaseComponent)(team4 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team4 == null ? IChatBaseComponent.i() : team4.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team4.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
            BingoTeam team5 = ScoreboardManager.getTeam(4);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._7, (IChatBaseComponent)(team5 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team5 == null ? IChatBaseComponent.i() : team5.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team5.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
            BingoTeam team6 = ScoreboardManager.getTeam(5);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._6, (IChatBaseComponent)(team6 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team6 == null ? IChatBaseComponent.i() : team6.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team6.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
            BingoTeam team7 = ScoreboardManager.getTeam(6);
            builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._5, (IChatBaseComponent)(team7 == null ? IChatBaseComponent.i() : IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i)), (IChatBaseComponent)(team7 == null ? IChatBaseComponent.i() : team7.getName().a(EnumChatFormat.h).b((IChatBaseComponent)IChatBaseComponent.b((String)" (").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size() - team7.getMissingBingoItems().size())).a(EnumChatFormat.k)).b((IChatBaseComponent)IChatBaseComponent.b((String)"/").a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)String.valueOf(BingoObject.getSelectedObjects().size())).a(EnumChatFormat.h)).b((IChatBaseComponent)IChatBaseComponent.b((String)")").a(EnumChatFormat.h))));
        }
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._4, (IChatBaseComponent)IChatBaseComponent.i(), (IChatBaseComponent)IChatBaseComponent.i());
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._3, (IChatBaseComponent)IChatBaseComponent.a((String)"game.team.your", (String)"Your Team").f(": ").a(EnumChatFormat.h), (IChatBaseComponent)BingoTeam.getTeam(player.getUniqueId()).map(BingoTeam::getName).orElse(IChatBaseComponent.a((String)"game.Spectator", (String)"Spectator").a(EnumChatFormat.h)));
        builder.updateScore(NMSScoreboardBuilder.ScoreboardEntry._2, (IChatBaseComponent)IChatBaseComponent.i(), (IChatBaseComponent)IChatBaseComponent.i());
        player.getScoreboard().getEntryTeam(NMSScoreboardBuilder.ScoreboardEntry._1.entry).setPrefix(ScoreboardManager.getAuthor());
    }

    public static void updateTime(Player player) {
        String time = ScoreboardManager.calcTime();
        NMSScoreboardBuilder.updateTitle(player.getScoreboard(), Main.bingoPrefix + (String)(time == null ? "" : String.valueOf(ChatColor.DARK_GRAY) + " - " + String.valueOf(ChatColor.GRAY) + time));
    }

    private static String calcTime() {
        long time;
        long l = time = (Integer)BingoSetting.getSetting(TimeSetting.class).getValue() == 0 ? System.currentTimeMillis() - GameState.time : GameState.time - System.currentTimeMillis();
        if (time <= 0L) {
            return null;
        }
        return String.format("%02d:%02d", time / 1000L / 60L, time / 1000L % 60L);
    }

    private static BingoTeam getTeam(int place) {
        Comparator<BingoTeam> comparator = Comparator.comparingInt(value -> value.getMissingBingoItems().size());
        LinkedList<BingoTeam> teams = new LinkedList<BingoTeam>(BingoTeam.teams.stream().sorted(comparator.thenComparingInt(BingoTeam::getId)).toList());
        if (place >= teams.size()) {
            return null;
        }
        return (BingoTeam)teams.get(place);
    }

    private static IChatBaseComponent getItem(Player player, int i) {
        Optional<BingoTeam> optionalTeam = BingoTeam.getTeam(player.getUniqueId());
        if (optionalTeam.isEmpty()) {
            return IChatBaseComponent.i();
        }
        List<BingoObject> sortedObjects = BingoObject.getSelectedObjects().stream().filter(bingoObject -> ((BingoTeam)optionalTeam.get()).getMissingBingoItems().contains(bingoObject)).toList();
        if (sortedObjects.size() <= i) {
            return IChatBaseComponent.i();
        }
        return sortedObjects.get(i).getName().a(sortedObjects.get(i) instanceof BingoObject.BingoItem.EnchantedBingoItem ? EnumChatFormat.l : EnumChatFormat.h);
    }

    private static BingoObject getObject(Player player, int i) {
        Optional<BingoTeam> optionalTeam = BingoTeam.getTeam(player.getUniqueId());
        if (optionalTeam.isEmpty()) {
            return null;
        }
        List<BingoObject> sortedObjects = BingoObject.getSelectedObjects().stream().filter(bingoObject -> ((BingoTeam)optionalTeam.get()).getMissingBingoItems().contains(bingoObject)).toList();
        if (sortedObjects.size() <= i) {
            return null;
        }
        return sortedObjects.get(i);
    }

    public static String getAuthor() {
        return Main.bingoPrefix + String.valueOf(ChatColor.GRAY) + " - v" + Main.plugin.getDescription().getVersion();
    }

    private static IChatMutableComponent getBingoObjectSymbol(Player player, int i) {
        if (ResourcepackListener.resourcepacks.contains(player.getUniqueId())) {
            return ScoreboardManager.getObject(player, i).getScoreboardIcon().f(" ");
        }
        return IChatBaseComponent.b((String)"- ").a(EnumChatFormat.i).f(" ");
    }
}

