/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.bingo.game;

import de.eisi05.bingo.Main;
import de.eisi05.bingo.bingo.BingoTeam;
import de.eisi05.bingo.game.GameState;
import de.eisi05.bingo.manager.ScoreboardManager;
import java.util.function.Function;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.minecraft.network.chat.IChatBaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GameActionBar {
    private static BukkitTask task;
    private static int counter;

    public static void enable() {
        task = new BukkitRunnable(){

            public void run() {
                Function<Player, BaseComponent> actionbar = player -> switch (GameState.currentGameState) {
                    default -> throw new MatchException(null, null);
                    case GameState.LOBBY -> {
                        if (player.isOp() && counter < 160) {
                            TranslatableComponent translatableComponent = new TranslatableComponent("game.operator", new Object[0]);
                            translatableComponent.setFallback("You are an operator");
                            translatableComponent.setColor(net.md_5.bungee.api.ChatColor.GRAY);
                            yield translatableComponent;
                        }
                        TranslatableComponent translatableComponent = new TranslatableComponent("game.waiting.operator", new Object[0]);
                        translatableComponent.setFallback("Waiting for operator");
                        translatableComponent.setColor(net.md_5.bungee.api.ChatColor.GRAY);
                        if (counter < 20 && counter >= 0 || counter < 100 && counter >= 80) {
                            yield GameActionBar.createComponent((BaseComponent)translatableComponent, 1);
                        }
                        if (counter < 40 && counter >= 20 || counter < 120 && counter >= 100) {
                            yield GameActionBar.createComponent((BaseComponent)translatableComponent, 2);
                        }
                        if (counter < 60 && counter >= 40 || counter < 140 && counter >= 120) {
                            yield GameActionBar.createComponent((BaseComponent)translatableComponent, 3);
                        }
                        if (counter < 80 && counter >= 60 || counter < 160 && counter >= 140) {
                            yield GameActionBar.createComponent((BaseComponent)translatableComponent, 4);
                        }
                        yield TextComponent.fromLegacy((String)(ScoreboardManager.getAuthor() + String.valueOf(ChatColor.GRAY) + " - v" + Main.plugin.getDescription().getVersion()));
                    }
                    case GameState.TEAM_SELECT -> {
                        TranslatableComponent translatableComponent = new TranslatableComponent(player.isOp() && counter < 160 ? "game.waiting.you" : "game.waiting.start", new Object[0]);
                        translatableComponent.setFallback(player.isOp() && counter < 160 ? "Waiting for you to start the game" : "Waiting for operator to start the game");
                        translatableComponent.setColor(net.md_5.bungee.api.ChatColor.GRAY);
                        translatableComponent.addExtra(TextComponent.fromLegacy((String)" "));
                        BaseComponent message = TextComponent.fromLegacy((String)" ");
                        message.addExtra((BaseComponent)translatableComponent);
                        if (counter < 20 && counter >= 0 || counter < 100 && counter >= 80) {
                            yield GameActionBar.createComponent(message, 1);
                        }
                        if (counter < 40 && counter >= 20 || counter < 120 && counter >= 100) {
                            yield GameActionBar.createComponent(message, 2);
                        }
                        if (counter < 60 && counter >= 40 || counter < 140 && counter >= 120) {
                            yield GameActionBar.createComponent(message, 3);
                        }
                        if (counter < 80 && counter >= 60 || counter < 160 && counter >= 140) {
                            yield GameActionBar.createComponent(message, 4);
                        }
                        yield BingoTeam.getTeam(player.getUniqueId()).map(team -> {
                            TranslatableComponent teamComponent = new TranslatableComponent("team.your", new Object[]{team.getName()});
                            teamComponent.setFallback("Your are in team " + CraftChatMessage.fromComponent((IChatBaseComponent)team.getName()));
                            teamComponent.setColor(net.md_5.bungee.api.ChatColor.GRAY);
                            return teamComponent;
                        }).orElseGet(() -> {
                            TranslatableComponent teamComponent = new TranslatableComponent("team.choose", new Object[0]);
                            teamComponent.setFallback("Choose your team");
                            teamComponent.setColor(net.md_5.bungee.api.ChatColor.GRAY);
                            return teamComponent;
                        });
                    }
                    case GameState.STARTING -> TextComponent.fromLegacy((String)Main.bingoPrefix);
                    case GameState.INGAME, GameState.RESTART -> TextComponent.fromLegacy((String)"");
                    case GameState.FINISH -> {
                        if (GameState.restartTime == -1L) {
                            TranslatableComponent component = new TranslatableComponent("deathScreen.title.hardcore", new Object[0]);
                            component.setFallback("Game over!");
                            component.setColor(net.md_5.bungee.api.ChatColor.RED);
                            yield component;
                        }
                        long seconds = (GameState.restartTime - System.currentTimeMillis()) / 1000L;
                        if (seconds <= 0L) {
                            new BukkitRunnable(this){

                                public void run() {
                                    GameState.setGameState(GameState.RESTART);
                                }
                            }.runTask(Main.plugin);
                            this.cancel();
                        }
                        TranslatableComponent component = new TranslatableComponent("deathScreen.title.hardcore", new Object[0]);
                        component.setFallback("Game over!");
                        component.addExtra(" ");
                        TranslatableComponent translatableComponent = new TranslatableComponent("game.restart", new Object[]{String.valueOf(ChatColor.GRAY) + seconds});
                        translatableComponent.setFallback("Server restarting in " + String.valueOf(ChatColor.GRAY) + seconds + " seconds!");
                        translatableComponent.setColor(net.md_5.bungee.api.ChatColor.RED);
                        component.addExtra((BaseComponent)translatableComponent);
                        component.setColor(net.md_5.bungee.api.ChatColor.RED);
                        yield component;
                    }
                };
                Bukkit.getOnlinePlayers().forEach(player -> player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)actionbar.apply((Player)player)));
                if (++counter >= 260) {
                    counter = 0;
                }
            }
        }.runTaskTimerAsynchronously(Main.plugin, 0L, 1L);
    }

    public static void disable() {
        if (task != null && (Bukkit.getScheduler().isQueued(task.getTaskId()) || Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId()))) {
            task.cancel();
        }
    }

    private static BaseComponent createComponent(BaseComponent component, int step) {
        component.addExtra(TextComponent.fromLegacy((String)(" " + GameActionBar.dots(step, false))));
        BaseComponent finalComponent = TextComponent.fromLegacy((String)(GameActionBar.dots(step, true) + " "));
        finalComponent.addExtra(component);
        return finalComponent;
    }

    private static String dots(int step, boolean isLeft) {
        String left = String.valueOf(ChatColor.GRAY) + ChatColor.BOLD.toString() + "\u25cf" + String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf".repeat(2) + String.valueOf(ChatColor.RESET);
        String mid = String.valueOf(ChatColor.DARK_GRAY) + ChatColor.BOLD.toString() + "\u25cf" + String.valueOf(ChatColor.RESET) + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.DARK_GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.RESET);
        String right = String.valueOf(ChatColor.DARK_GRAY) + ChatColor.BOLD.toString() + "\u25cf".repeat(2) + String.valueOf(ChatColor.GRAY) + String.valueOf(ChatColor.BOLD) + "\u25cf" + String.valueOf(ChatColor.RESET);
        return switch (step) {
            case 1 -> {
                if (isLeft) {
                    yield left;
                }
                yield right;
            }
            case 2, 4 -> mid;
            case 3 -> {
                if (isLeft) {
                    yield right;
                }
                yield left;
            }
            default -> null;
        };
    }

    static {
        counter = 0;
    }
}

